/* [getstr.c wk 20.1.88] GetStr()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 12.04.93 wk	GetStr(15) now display up to 20 chars (old was 1)
 * 03.08.93 wk	Added messages for r.e.
 */

#include <wk/tailor.h>
RCSID("$Id: getstr.c,v 1.5 1995/03/08 16:55:51 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/lib.h>

#ifdef DOCUMENTATION
@Summary GetStr 	   get standard text

 const char *GetStr( n );
 int	n ;		Nummer des textes
@Description
 Diese Funktion liefert eine konstanten Textstring mit der Nummer n
 zurck.
@Return Value
 Pointer to the  const string
#endif

const char *GetStr( int n )
{
    static const char *list[] = {
 /* 0*/ "Out of core",
 /* 1*/ "Can't open `%s'",
 /* 2*/ "Error reading `%s'",
 /* 3*/ "Error writing `%s'",
 /* 4*/ "Error closing `%s'",
 /* 5*/ "Can't create `%s'",
 /* 6*/ "Can't delete `%s'",
 /* 7*/ "Error seeking `%s'",
 /* 8*/ "Can't create unique filename",
 /* 9*/ "Can't create workfile `%s'",
 /*10*/ "Can't continue",
 /*11*/ "No permission",
 /*12*/ "Error expanding args",     /* Error getting status of `%s'"*/
 /*13*/ "", /*[old] error recreating `%s'",*/
 /*14*/ "", /* [old] can't continue", */
 /*15*/ "Invalid option '-%.20s'",
 /*16*/ "Warning: ignoring option %s",
 /*17*/ "", /*[old] can't copy file into itself"*/
 /*18*/ "", /*[old] warning: records will be truncated"*/
 /*19*/ "", /*[old] ....",*/
 /*20*/ " Terminated by user",
 /*21*/ "", /*[old] error updating in file `%s'"*/
 /*22*/ "", /*[old] error inserting in file `%s'"*/
 /*23*/ "", /*[old] inconsistent file `%s'",*/
 /*24*/ "", /*[old] not enough core to edit `%s'"*/
 /*25*/ "", /* [old] file `%s' is too large to edit"*/
 /*26*/ "error compiling r.e.",
 /*27*/ "", /*[old] can't insert more characters"*/
 /*28*/ "", /*[old] You have made changes since the last save"*/
 /*29*/ "", /*[old] FATAL: version check of file `%s' failed"*/
 /*30*/ "FPE 0x80",
 /*31*/ "FPE invalid",
 /*32*/ "FPE denormal",
 /*33*/ "FPE divide by zero",
 /*34*/ "FPE overflow",
 /*35*/ "FPE underflow",
 /*36*/ "FPE inexact",
 /*37*/ "FPE unemulated",
 /*38*/ "FPE negative square root",
 /*39*/ "FPE 0x89",
 /*40*/ "FPE stack overflow",
 /*41*/ "FPE stack underflow",
 /*42*/ "FPE explicit generated",
 /*43*/ "FPE 0x8d",
 /*44*/ "FPE 0x8e",
 /*45*/ "FPE 0x8f",
 /*46*/ "Can't create directory `%s'",
 /*47*/ "Can't change to `%s'",
 /*48*/ "Can't remove directory `%s'",
 /*49*/ "Directory not allowed",
 /*50*/ "Drive missing",
 /*51*/ "No files found"
    } ;

    if( n >= 0 && n <= 51 )
	if( list[n] )
	    return list[n];
    Fatal("GetStr(%d)", n );
    return "?";
}

/*** bottom of file */
