/* [infostr.c wk 26.5.91] WklibInfoString()
 *	Copyright (c) 1994 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: infostr.c,v 1.6 1996/06/07 15:53:01 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/lib.h>

#if __WATCOMC__ && __SW_3S && !defined(NETWARE)
  #define LINKER_INFO _wklib_linker_info
#else
  #define LINKER_INFO wklib_linker_info
#endif
extern const char * LINKER_INFO;

const char *
WklibInfoString( const char *module, const char*name )
{
    const char *s = LINKER_INFO;
    const char *r;

    if( !s )
	return NULL; /* String nicht initialisiert */
    if( module )
	return NULL; /* info strings from DLLs are not yet supported*/

    for(r=name;;) {
	for( ; *s && *s == *r; s++, r++)
	    ;
	if( !*r ) {
	    if( *s == '=' )
		return s+1;
	    else if( !*s )
		return s;  /* no value assigned */
	}
	r = name;
	while(*s)
	    s++;
	if( !*++s )
	    return NULL;
    }
    /*NOTREACHED*/
}

/***** bottom of file ******/
