/* [kbd.c wk 11.4.89] Keyboard Functions
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 27.01.93 wk	C Set/2 Support - via kbhit(),getch()
 * 07.07.94 wk	WATCOM and windows support
 */

#include <wk/tailor.h>
RCSID("$Id: kbd.c,v 1.10 1996/04/18 14:32:17 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <wk/lib.h>
#if __ZTC__ || __MSC__ || __WATCOMC__
  #include <bios.h>
#elif __IBMC__
#endif
#include <wk/keys.h>


#ifdef DOCUMENTATION
@Summary Inkey	      Get a Key from the Keyboard
 #include <wk/keys.h>

 int Inkey( void );
@Description
 Holt eine KeyCode vom Keyboard
@Return Value
 KeyCode ( K_... ) or 0 if no key pressed
#endif


int Inkey(void)
{
    int  c ;

  #if EMX
    c = _read_kbd(0, 0, 0 );
    if( c != -1 ) {
	if( !c )
	    c = (_read_kbd(0, 0, 0 ) << 8) & 0xff00;
	else
	    c &= 0xff;

  #elif __ZTC__
    if( bioskey(1) ) {
	c = bioskey(0);
  #elif __MSC__  || (__WATCOMC__ && (MSDOS || DOS386))
    Sleep(0);
    if( _bios_keybrd(_KEYBRD_READY) ) {
	c = _bios_keybrd(_KEYBRD_READ);
  #elif __IBMC__ || __WATCOMC__
    Sleep(0);
    if( kbhit() ) {
	if( c = getch() )
	    c &= 0xff;
	else
	    c = (getch() << 8) & 0xff00;
  #elif UNIX
    if( (c = getchar()) != EOF ) {
	if( c == '\n' )
	    c = K_RETURN;
  #elif GNU_C_LIB_OS2 || __GNU_LIBRARY__
    /* this is not a true working implementation */
    if( (c = getchar()) != EOF ) {
	if( c )
	    c &= 0xff;
	else {
	    c = getchar();
	    c = (c << 8) & 0xff00;
	}
  #elif POSIX
    if( (c = getchar()) != EOF ) {
	if( c == '\n' )
	    c = K_RETURN;
  #else
    #error Inkey() not implemented for this compiler/OS
  #endif
      #ifndef _WINDOWS
	if( (c & 0xff) == 0x03 ) {  /* Control-C ? */
	    raise(SIGINT);
	    return 0;
	}
	else
       #endif
	     if( c & 0xff )
	    return c & 0xff ;
	else
	    return ((c >> 8) & 0xff) + 256 ;
    }
    else
	return 0;

}

/**** end of file ****/
