/* [kbdstr1.c wk 28.02.95] Strings for key.h
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: kbdstr1.c,v 1.2 1995/03/08 16:56:19 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <wk/lib.h>
#define INCL_ALT_KEYCODES 1
#define INCL_CTRL_KEYCODES 1
#include <wk/keys.h>
#include <wk/string.h>


#ifdef DOCUMENTATION
@Summary WklibKeyCode2String Return a descriptive String for a Keycode
 #include <wk/keys.h>

 const char *WklibKeyCode2String( int code );
 int WklibString2KeyCode( const char *str );
@Description
@Return Value
 KeyCode ( K_... ) or 0 if no key pressed
 Returns a String for the given keycode or an empty string if it ist a unknown
#endif


const char *WklibKeyCode2String( int code )
{
    const char *p;

    switch(code) {
      case K_RETURN	   : p = "return"; break;
      case K_CRETURN	   : p = "c-return"; break;
      case K_ESCAPE	   : p = "escape"; break;
      case K_RUBOUT	   : p = "rubout"; break;
      case K_CRUBOUT	   : p = "c-rubout"; break;
      case K_ARUBOUT	   : p = "a-rubout"; break;
      case K_TAB	   : p = "tab"; break;
      case K_BACKTAB	   : p = "backtab"; break;
      case K_LEFT	   : p = "left"; break;
      case K_CLEFT	   : p = "c-left"; break;
      case K_ALEFT	   : p = "a-left"; break;
      case K_RIGHT	   : p = "right"; break;
      case K_CRIGHT	   : p = "c-right"; break;
      case K_ARIGHT	   : p = "a-right"; break;
      case K_UP 	   : p = "up"; break;
      case K_CUP	   : p = "c-up"; break;
      case K_AUP	   : p = "a-up"; break;
      case K_DOWN	   : p = "down"; break;
      case K_CDOWN	   : p = "c-down"; break;
      case K_ADOWN	   : p = "a-down"; break;
      case K_PGUP	   : p = "pgup"; break;
      case K_CPGUP	   : p = "c-pgup"; break;
      case K_APGUP	   : p = "a-pgup"; break;
      case K_PGDN	   : p = "pgdn"; break;
      case K_CPGDN	   : p = "c-pgdn"; break;
      case K_APGDN	   : p = "a-pgdn"; break;
      case K_HOME	   : p = "home"; break;
      case K_CHOME	   : p = "c-home"; break;
      case K_AHOME	   : p = "a-home"; break;
      case K_END	   : p = "end"; break;
      case K_CEND	   : p = "c-end"; break;
      case K_AEND	   : p = "a-end"; break;
      case K_DEL	   : p = "del"; break;
      case K_CDEL	   : p = "c-del"; break;
      case K_ADEL	   : p = "a-del"; break;
      case K_INS	   : p = "ins"; break;
      case K_CINS	   : p = "c-ins"; break;
      case K_AINS	   : p = "a-ins"; break;
      case K_F1 	   : p = "f1"; break;
      case K_F2 	   : p = "f2"; break;
      case K_F3 	   : p = "f3"; break;
      case K_F4 	   : p = "f4"; break;
      case K_F5 	   : p = "f5"; break;
      case K_F6 	   : p = "f6"; break;
      case K_F7 	   : p = "f7"; break;
      case K_F8 	   : p = "f8"; break;
      case K_F9 	   : p = "f9"; break;
      case K_F10	   : p = "f10"; break;
      case K_SF1	   : p = "s-f1"; break;
      case K_SF2	   : p = "s-f2"; break;
      case K_SF3	   : p = "s-f3"; break;
      case K_SF4	   : p = "s-f4"; break;
      case K_SF5	   : p = "s-f5"; break;
      case K_SF6	   : p = "s-f6"; break;
      case K_SF7	   : p = "s-f7"; break;
      case K_SF8	   : p = "s-f8"; break;
      case K_SF9	   : p = "s-f9"; break;
      case K_SF10	   : p = "s-f10"; break;
      case K_CF1	   : p = "c-f1"; break;
      case K_CF2	   : p = "c-f2"; break;
      case K_CF3	   : p = "c-f3"; break;
      case K_CF4	   : p = "c-f4"; break;
      case K_CF5	   : p = "c-f5"; break;
      case K_CF6	   : p = "c-f6"; break;
      case K_CF7	   : p = "c-f7"; break;
      case K_CF8	   : p = "c-f8"; break;
      case K_CF9	   : p = "c-f9"; break;
      case K_CF10	   : p = "c-f10"; break;
      case K_AF1	   : p = "a-f1"; break;
      case K_AF2	   : p = "a-f2"; break;
      case K_AF3	   : p = "a-f3"; break;
      case K_AF4	   : p = "a-f4"; break;
      case K_AF5	   : p = "a-f5"; break;
      case K_AF6	   : p = "a-f6"; break;
      case K_AF7	   : p = "a-f7"; break;
      case K_AF8	   : p = "a-f8"; break;
      case K_AF9	   : p = "a-f9"; break;
      case K_AF10	   : p = "a-f10"; break;
      case K_F11	   : p = "f11"; break;
      case K_F12	   : p = "f12"; break;
      case K_SF11	   : p = "s-f11"; break;
      case K_SF12	   : p = "s-f12"; break;
      case K_CF11	   : p = "c-f11"; break;
      case K_CF12	   : p = "c-f12"; break;
      case K_AF11	   : p = "a-f11"; break;
      case K_AF12	   : p = "a-f12"; break;
      case K_CA 	   : p = "c-a"; break;
      case K_CB 	   : p = "c-b"; break;
      case K_CC 	   : p = "c-c"; break;
      case K_CD 	   : p = "c-d"; break;
      case K_CE 	   : p = "c-e"; break;
      case K_CF 	   : p = "c-f"; break;
      case K_CG 	   : p = "c-g"; break;
   /* case K_CH 	   : p = "c-h"; break; same as K_RUBOUT */
   /* case K_CI 	   : p = "c-i"; break; same as K_TAB */
   /* case K_CJ 	   : p = "c-j"; break; sane as K_CRETURN */
      case K_CK 	   : p = "c-k"; break;
      case K_CL 	   : p = "c-l"; break;
   /* case K_CM 	   : p = "c-m"; break; same as K_RETURN */
      case K_CN 	   : p = "c-n"; break;
      case K_CO 	   : p = "c-o"; break;
      case K_CP 	   : p = "c-p"; break;
      case K_CQ 	   : p = "c-q"; break;
      case K_CR 	   : p = "c-r"; break;
      case K_CS 	   : p = "c-s"; break;
      case K_CT 	   : p = "c-t"; break;
      case K_CU 	   : p = "c-u"; break;
      case K_CV 	   : p = "c-v"; break;
      case K_CW 	   : p = "c-w"; break;
      case K_CX 	   : p = "c-x"; break;
      case K_CY 	   : p = "c-y"; break;
      case K_CZ 	   : p = "c-z"; break;
      case K_AA 	   : p = "a-a"; break;
      case K_AB 	   : p = "a-b"; break;
      case K_AC 	   : p = "a-c"; break;
      case K_AD 	   : p = "a-d"; break;
      case K_AE 	   : p = "a-e"; break;
      case K_AF 	   : p = "a-f"; break;
      case K_AG 	   : p = "a-g"; break;
      case K_AH 	   : p = "a-h"; break;
      case K_AI 	   : p = "a-i"; break;
      case K_AJ 	   : p = "a-j"; break;
      case K_AK 	   : p = "a-k"; break;
      case K_AL 	   : p = "a-l"; break;
      case K_AM 	   : p = "a-m"; break;
      case K_AN 	   : p = "a-n"; break;
      case K_AO 	   : p = "a-o"; break;
      case K_AP 	   : p = "a-p"; break;
      case K_AQ 	   : p = "a-q"; break;
      case K_AR 	   : p = "a-r"; break;
      case K_AS 	   : p = "a-s"; break;
      case K_AT 	   : p = "a-t"; break;
      case K_AU 	   : p = "a-u"; break;
      case K_AV 	   : p = "a-v"; break;
      case K_AW 	   : p = "a-w"; break;
      case K_AX 	   : p = "a-x"; break;
      case K_AY 	   : p = "a-y"; break;
      case K_AZ 	   : p = "a-z"; break;
      case K_A0 	   : p = "a-0"; break;
      case K_A1 	   : p = "a-1"; break;
      case K_A2 	   : p = "a-2"; break;
      case K_A3 	   : p = "a-3"; break;
      case K_A4 	   : p = "a-4"; break;
      case K_A5 	   : p = "a-5"; break;
      case K_A6 	   : p = "a-6"; break;
      case K_A7 	   : p = "a-7"; break;
      case K_A8 	   : p = "a-8"; break;
      case K_A9 	   : p = "a-9"; break;
      case K_PAD_INS	   : p = "pad-ins"; break;
      case K_PAD_1	   : p = "pad-1"; break;
      case K_PAD_2	   : p = "pad-2"; break;
      case K_PAD_3	   : p = "pad-3"; break;
      case K_PAD_4	   : p = "pad-4"; break;
      case K_PAD_5	   : p = "pad-5"; break;
      case K_PAD_6	   : p = "pad-6"; break;
      case K_PAD_7	   : p = "pad-7"; break;
      case K_PAD_8	   : p = "pad-8"; break;
      case K_PAD_9	   : p = "pad-9"; break;
      case K_PAD_SINS	   : p = "s-pad-ins"; break;
      case K_PAD_S1	   : p = "s-pad-1"; break;
      case K_PAD_S2	   : p = "s-pad-2"; break;
      case K_PAD_S3	   : p = "s-pad-3"; break;
      case K_PAD_S4	   : p = "s-pad-4"; break;
      case K_PAD_S5	   : p = "s-pad-5"; break;
      case K_PAD_S6	   : p = "s-pad-6"; break;
      case K_PAD_S7	   : p = "s-pad-7"; break;
      case K_PAD_S8	   : p = "s-pad-8"; break;
      case K_PAD_S9	   : p = "s-pad-9"; break;
      case K_PAD_CINS	   : p = "c-pad-ins"; break;
      case K_PAD_C1	   : p = "c-pad-1"; break;
      case K_PAD_C2	   : p = "c-pad-2"; break;
      case K_PAD_C3	   : p = "c-pad-3"; break;
      case K_PAD_C4	   : p = "c-pad-4"; break;
      case K_PAD_C5	   : p = "c-pad-5"; break;
      case K_PAD_C6	   : p = "c-pad-6"; break;
      case K_PAD_C7	   : p = "c-pad-7"; break;
      case K_PAD_C8	   : p = "c-pad-8"; break;
      case K_PAD_C9	   : p = "c-pad-9"; break;
      case K_PAD_AINS	   : p = "a-pad-ins"; break;
      case K_PAD_A1	   : p = "a-pad-1"; break;
      case K_PAD_A2	   : p = "a-pad-2"; break;
      case K_PAD_A3	   : p = "a-pad-3"; break;
      case K_PAD_A4	   : p = "a-pad-4"; break;
      case K_PAD_A5	   : p = "a-pad-5"; break;
      case K_PAD_A6	   : p = "a-pad-6"; break;
      case K_PAD_A7	   : p = "a-pad-7"; break;
      case K_PAD_A8	   : p = "a-pad-8"; break;
      case K_PAD_A9	   : p = "a-pad-9"; break;
      case K_PAD_DEL	   : p = "pad-del"; break;
      case K_PAD_PLUS	   : p = "pad-plus"; break;
      case K_PAD_MINUS	   : p = "pad-minus"; break;
      case K_PAD_RETURN    : p = "pad-return"; break;
      case K_PAD_MUL	   : p = "pad-mul"; break;
      case K_PAD_DIV	   : p = "pad-div"; break;
      case K_PAD_SDEL	   : p = "s-pad-del"; break;
      case K_PAD_SPLUS	   : p = "s-pad-plus"; break;
      case K_PAD_SMINUS    : p = "s-pad-minus"; break;
      case K_PAD_SRETURN   : p = "s-pad-return"; break;
      case K_PAD_SMUL	   : p = "s-pad-mul"; break;
      case K_PAD_SDIV	   : p = "s-pad-div"; break;
      case K_PAD_CDEL	   : p = "s-pad-del"; break;
      case K_PAD_CPLUS	   : p = "c-pad-plus"; break;
      case K_PAD_CMINUS    : p = "c-pad-minus"; break;
      case K_PAD_CRETURN   : p = "c-pad-return"; break;
      case K_PAD_CMUL	   : p = "c-pad-mul"; break;
      case K_PAD_CDIV	   : p = "c-pad-div"; break;
      case K_PAD_ADEL	   : p = "a-pad-del"; break;
      case K_PAD_APLUS	   : p = "a-pad-plus"; break;
      case K_PAD_AMINUS    : p = "a-pad-minus"; break;
      case K_PAD_ARETURN   : p = "a-pad-return"; break;
      case K_PAD_AMUL	   : p = "a-pad-mul"; break;
      case K_PAD_ADIV	   : p = "a-pad-div"; break;
      case K_VK_RETURN	   : p = "v-return"; break;
      case K_VK_ESCAPE	   : p = "v-escape"; break;
      case K_VK_RUBOUT	   : p = "v-rubout"; break;
      case K_VK_TAB	   : p = "v-tab"; break;
      case K_VK_COMPOSED   : p = "v-composed"; break;
      case K_PRINT	   : p = "print"; break;
      case K_SCROLL	   : p = "scroll"; break;
      case K_PAUSE	   : p = "pause"; break;
      case K_NUMLCK	   : p = "numlck"; break;
      case K_CAPLCK	   : p = "caplck"; break;
      case K_BREAK	   : p = "break"; break;
      case K_EXIT	   : p = "exit"; break;
      case K_BTN_LEFT	   : p = "btn-left"; break;
      case K_BTN_RIGHT	   : p = "btn-right"; break;
      case K_BTN_LEFTDBL   : p = "btn-leftdbl"; break;
      case K_BTN_RIGHTDBL  : p = "btn-rightdbl"; break;
      case K_USER_FNC0	   : p = "user-fnc0"; break;
      case K_USER_FNC1	   : p = "user-fnc1"; break;
      case K_USER_FNC2	   : p = "user-fnc2"; break;
      case K_USER_FNC3	   : p = "user-fnc3"; break;
      case K_USER_FNC4	   : p = "user-fnc4"; break;
      case K_USER_FNC5	   : p = "user-fnc5"; break;
      case K_USER_FNC6	   : p = "user-fnc6"; break;
      case K_USER_FNC7	   : p = "user-fnc7"; break;
      case K_CMD_MENUSEL   : p = "cmd-menusel"; break;
      case K_CMD_MENUESC   : p = "cmd-menuesc"; break;
      case K_CMD_EDITSTART : p = "cmd-editstart"; break;
      case K_CMD_EDITEND   : p = "cmd-editend"; break;
      case K_CMD_EDITUPD   : p = "cmd-editupd"; break;
      case K_CMD_DUMMY_0   : p = "cmd-dummy-0"; break;
      case K_CMD_DUMMY_1   : p = "cmd-dummy-1"; break;
      case K_CMD_DUMMY_2   : p = "cmd-dummy-2"; break;
      case K_CMD_DUMMY_3   : p = "cmd-dummy-3"; break;
      case K_CMD_DUMMY_4   : p = "cmd-dummy-4"; break;
      case K_CMD_USER_0    : p = "cmd-user-0"; break;
      case K_CMD_USER_1    : p = "cmd-user-1"; break;
      case K_CMD_USER_2    : p = "cmd-user-2"; break;
      case K_CMD_USER_3    : p = "cmd-user-3"; break;
      case K_CMD_USER_4    : p = "cmd-user-4"; break;
      default: p = ""; break;
    }
    return p;
}




/****************
 * Very quick and dirty, but it should work
 */

int WklibString2KeyCode( const char *string )
{
    int code;

    if( *string )
	for(code=0; code < K_USER_BASE; code++ )
	    if( !stricmp( string, WklibKeyCode2String(code) ) )
		return code;
    if( !stricmp(string,"c-h") )
	return K_RUBOUT;
    else if( !stricmp(string,"c-i") )
	return K_TAB;
    else if( !stricmp(string,"c-j") )
	return K_CRETURN;
    else if( !stricmp(string,"c-m") )
	return K_RETURN;
    else
	return 0;
}

/**** end of file ****/
