# [libdflt.mak wk 13.10.91] Include for makefiles
#     Copyright (c) 1988-93 by Werner Koch (dd9jn)
# This file is part of WkLib.
#
# WkLib is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# WkLib is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#--------------------------------------------------
# Defines common macros for makefiles:
#  OS  defaults to MSDOS
#  MODEL  defaults to S (but forced to F when OS20 defined,
#			     forced to E when EMX defined  )
#  CCTYPE defaults to ZTC
# Shorthands:
#  D  will define DEBUG
# Composed Macros
#  LIBID  String composed from MODEL, CCTYPE, OS and DEBUG
#
# Aufbau der libname: *abcd
#   wobei: a : Z - Zortech Compiler  (CCTYPE=ZTC)
#	       M - Microsoft Compiler(CCTYPE=MSC)
#	       G - GNU C Compiler    (CCTYPE=GNU)
#	       I - IBM C Set/2	     (CCTYPE=IBM)
#	       W - Watcom-C	     (CCTYPE=WTC)
#	   b : S,M,C,L,V,Z,X,E,F,N - verwendetes Memory Model
#	       (Small,Medium,Compact,Large,VCM,DOS16RM,DOSX,EMX,Flat,NLM)
#	   c : 0 - Code fr MSDOS, 8086 Processor
#	       1 - Code fr 16-Windows. (ab 286-processor)
#	       2 - Code fr OS2, Version 1.x
#	       3 - Code fr OS2, Version 2.x  i386 processor, NLM
#	       4 - dito, aber multithreaded
#	   d : wenn vorhanden:
#	       D - DebugVersion der Library ( mit MEM_DEBUG und -g )
#
#
# EnvVars:
#   OS=MSDOS|OS2|OS20|EMX|WINDOWS|NETWARE
#   CCTYPE=ZTC|GNU|MSC|IBM|WTC
#--------------------------------------------------
# $Id: libdflt.mak,v 1.29 1996/01/10 19:05:59 wernerk Exp $
# History:
#  29.12.92 wk	Erweiterung fuer EMX (model E, OS EMX)
#  02.03.94 wk	Optimierung bei C/Set ausgeschaltet
#  04.07.94 wk	Erweitert um WATCOM-C
#  05.01.95 wk	ldsh wird nun auch unter UNIX benutzt
#  16.01.95 wk	Neues FLAG DO_NOT_OPTIMIZE (WTC)

nullstring :=
space := $(nullstring) $(nullstring)
backslash := $(nullstring)\$(nullstring)
#-- define a LF; notice the two blank lines inside the define block
define linefeed


endef


ifdef D       # shorthand for DEBUG
DEBUG = 1
endif

ifndef OS
OS=UNIX
endif

ifndef CCTYPE
CCTYPE=GNU
endif

ifeq ($(OS),UNIX)
MODEL := S
endif

ifeq ($(OS),OS20)
MODEL := F
endif
ifeq ($(OS),EMX)
MODEL := E
endif
ifeq ($(OS),NETWARE)
MODEL := N
endif


ifndef MODEL
ifeq ($(OS),WINDOWS)
MODEL := L
else
MODEL := S
endif
endif

#**********************************************
#********* Compiler specifics *****************
#**********************************************

ifeq ($(CCTYPE),IBM)
#**********************************************
#************* IBM C-Set/2 ********************
#**********************************************
ifeq ($(OS),OS20)
LIBID := I$(MODEL)
ifdef MULTI
OS2_MULTI=1
CC := icc -Q -Sm -Gm
ADD_DLL_LIBS := dde4mbso.lib  os2386.lib
else
OS2_MULTI=
CC := icc -Q -Sm
ADD_DLL_LIBS := dde4sbso.lib  os2386.lib
endif

else
errorIBMCForNonOS20:
	@echo C Set/2 is only valid for 32 bit Flat model
	abort
endif

endif #-- IBM --

ifeq ($(CCTYPE),ZTC)
#**********************************************
#************* Zortech 3.0 ********************
#**********************************************

LIBID := Z$(MODEL)
ifdef DPMI_OKAY
CC := ztc
else
CC := ztc -b
endif

ifeq ($(OS),OS2)
LIB    := $(PLIB);$(LIB)
endif

endif #-- Zortech --

ifeq ($(CCTYPE),WTC)
#**********************************************
#************* Watcom-C 10.0 ******************
#**********************************************

LIBID := W$(MODEL)
ifeq ($(MODEL),F)
CC := wcc386 -zq
else
ifeq ($(MODEL),X)
CC := wcc386 -zq
else
ifeq ($(MODEL),N)
CC := wcc386 -zq
else
CC := wcc -zq
CC_is_16_bit := 1
endif
endif
endif

endif #-- Watcom --

ifeq ($(CCTYPE),GNU)
#**********************************************
#************* A GNU System *******************
#**********************************************

LIBID=G$(MODEL)
ifeq ($(OS),UNIX)
CC := gcc -Wall -Wno-parentheses -pipe
else
CC := gcc -Wall -Wno-parentheses
endif
endif #-- GNU --


ifeq ($(CCTYPE),HPUX)
#**********************************************
#************* HPUX (PIC) *********************
#**********************************************

LIBID=C$(MODEL)
CC := c89 -z  -I$(WKLIBS)

endif

ifeq ($(CCTYPE),MSC)
#**********************************************
#************* Microsoft C ********************
#**********************************************

LIBID := M$(MODEL)
CC := cl -nologo

endif #-- MSC --


#**********************************************
#********* Correct some vars ******************
#**********************************************

#--- Fuer einige Models das OS umdefinieren ---
ifeq ($(MODEL),X)
override OS := DOS386
endif
ifeq ($(MODEL),Z)
override OS := DOS16RM
endif
ifeq ($(MODEL),E)
override OS := EMX
endif

#--- LIBID vervollstaendigen ---
ifeq ($(OS),UNIX)
LIBID := $(LIBID)0
endif
ifeq ($(OS),MSDOS)
LIBID := $(LIBID)0
endif
ifeq ($(OS),WINDOWS)
LIBID := $(LIBID)1
endif
ifeq ($(OS),DOS386)
LIBID := $(LIBID)0
endif
ifeq ($(OS),EMX)
LIBID := $(LIBID)0
endif
ifeq ($(OS),DOS16RM)
LIBID := $(LIBID)0
endif
ifeq ($(OS),OS2)
OS2x = 1
LIBID := $(LIBID)2
endif
ifeq ($(OS),OS20)
OS2x = 1
ifdef OS2_MULTI
LIBID := $(LIBID)4
else
LIBID := $(LIBID)3
endif
endif
ifeq ($(OS),NETWARE)
LIBID := $(LIBID)3
endif
ifndef OS
errorNoOS:
	echo Invalid OS Macro
	abort
endif

ifdef DEBUG
LIBID := $(LIBID)D
override LDFLAGS := $(LDFLAGS) -g
endif

ifndef OS_SUB
OS_SUB := $(OS)
endif


#**********************************************
#********* Compiler Flags *********************
#**********************************************

ifeq ($(CCTYPE),IBM)
#**********************************************
#************* IBM C-Set/2 ********************
#**********************************************

ifdef DEBUG
CFLAGS = -c -D$(OS) -DDEBUG -DMEM_DEBUG -Ti -Fo$@
else
CFLAGS = -c -D$(OS) -Fo$@   # removed the -O flag; doesn't work correct
			    # e.g. the MemStr() function doesn't work
endif

endif #-- IBM --

ifeq ($(CCTYPE),ZTC)
#**********************************************
#************* Zortech 3.0 ********************
#**********************************************

ifeq ($(MODEL),X)   # ztc definiert bereits selbst das OS
CFLAGS_1 := -r -R -m$(MODEL) -w2 -w6 -c
else
CFLAGS_1 := -r -R -m$(MODEL) -w2 -w6 -c -D$(OS)
endif
ifneq ($(MODEL),X)
ifneq ($(MODEL),Z)
CFLAGS_1 := $(CFLAGS_1) -g
endif
endif
ifdef DEBUG
CFLAGS = $(CFLAGS_1) -D -DMEM_DEBUG -o$@
else
CFLAGS = $(CFLAGS_1) -o -o$@
endif

endif #-- Zortech --

ifeq ($(CCTYPE),WTC)
#**********************************************
#************* Watcom-C 10.0 ******************
#**********************************************

ifeq ($(OS),MSDOS)
CFLAGS_1 := -bt=DOS -m$(MODEL)
endif
ifeq ($(OS),WINDOWS)
CFLAGS_1 := -bt=windows -m$(MODEL) -2 -zu
endif
ifeq ($(OS),DOS386)
CFLAGS_1 := -bt=dos4g -D$(OS)=1
endif
ifeq ($(OS),OS2)
export OS2_INCLUDE := $(OS2_1X_INCLUDE)
CFLAGS_1 := -bt=OS2 -m$(MODEL) -D$(OS)
endif
ifeq ($(OS),OS20)
export OS2_INCLUDE := $(OS2_2X_INCLUDE)
CFLAGS_1 := -bt=OS2 -m$(MODEL) -D$(OS)
endif
ifeq ($(OS),NETWARE)
CFLAGS_1 := -bt=netware -D$(OS)
endif

ifdef DEFAULT_WINDOWING
CFLAGS_1 := $(CFLAGS_1) -bw
endif
ifdef DO_NOT_OPTIMIZE
CFLAGS_1 := $(CFLAGS_1) -od
endif

ifdef DEBUG
CFLAGS = $(CFLAGS_1) -d2 -dDEBUG=1 -dMEM_DEBUG=1 -fo=$(subst /,\\,$@)
else
CFLAGS = $(CFLAGS_1) -fo=$(subst /,\\,$@)
endif

endif #-- Watcom --

ifeq ($(CCTYPE),GNU)
#**********************************************
#************* A GNU System *******************
#**********************************************

ifdef DEBUG
CFLAGS = -g -DDEBUG -DMEM_DEBUG  -c -xc -D$(OS) -o $@
else
CFLAGS = -O2 -c -xc -D$(OS) -o $@
endif

endif #-- GNU --

ifeq ($(CCTYPE),HPUX)
#**********************************************
#************* A HPUX System *******************
#**********************************************

ifdef DEBUG
CFLAGS = -g -DDEBUG -DMEM_DEBUG  -c -D$(OS) -o $@
else
CFLAGS = -O -c -D$(OS) -o $@
endif

override LDFLAGS := $(LDFLAGS) -posix

endif

ifeq ($(CCTYPE),STD)
#**********************************************
#************* Standard System *******************
#**********************************************

ifdef DEBUG
CFLAGS = -g -DDEBUG -DMEM_DEBUG  -c -I/usr/local/include -D$(OS) -o $@
else
CFLAGS = -O -c	-I/usr/local/include  -D$(OS) -o $@
endif

endif

ifeq ($(CCTYPE),MSC)
#**********************************************
#************* Microsoft C ********************
#**********************************************


ifeq ($(OS),MSDOS)
CFLAGS_1 := -A$(MODEL) -c -D$(OS)
else
CFLAGS_1 := -A$(MODEL) -c -G2 -UMSDOS -D$(OS)
endif
ifdef DEBUG
CFLAGS = -qc $(CFLAGS_1) -Zi -DDEBUG -DMEM_DEBUG -Fo$@
else
CFLAGS = $(CFLAGS_1) -Fo$@
endif


endif #-- MSC --

#**********************************************
#********* Some more vars *********************
#**********************************************

ifeq ($(OS),UNIX)
x := $(nullstring)
o := .o
a := .a
s := .sa
else
ifeq ($(OS),NETWARE)
x := .nlm
else
x := .exe
endif
o := .obj
a := .lib
s := .dll
endif


WKLIBPATH   = $(WKLIBS)/lib
WKLIB	   := wk1$(LIBID)$a
WKLIB_FULL := $(WKLIBS)/lib/$(WKLIB)
ifeq ($(CCTYPE),WTC)  # wir haben noch keine Watcom import libraries
WKLIB4DLL  := wk1$(LIBID)$a
LDFLAGS4DLL :=
else
ifeq ($(CCTYPE),HPUX)
WKLIB4DLL  := $(WKLIB_FULL)
LDFLAGS4DLL := "-Wl,-E,+s,-b -v"
else
WKLIB4DLL  := wk1$(LIBID)i$a
LDFLAGS4DLL := -jn
endif
endif

OBJPATH := $(OBJPATH_PREFIX)$(LIBID)
EXEPATH := $(EXEPATH_PREFIX)$(LIBID)

CPP := cpp
RM  := rm -q


vpath %$o   $(OBJPATH)
vpath %.res $(OBJPATH)
vpath %.map $(EXEPATH)
vpath %$x   $(EXEPATH)
vpath %$s   $(EXEPATH)
vpath %$a   $(WKLIBS)/lib

#**********************************************
#********* Pattern rules **********************
#**********************************************


$(OBJPATH)/%$o	 :: %.l
	  flex -t -8 $*.l >$*.c
	  $(CC) $(ADD_CFLAGS) $(CFLAGS) $*.c



$(OBJPATH)/%$o	 :: %.c
	  $(CC) $(ADD_CFLAGS) $(CFLAGS) $*.c

$(OBJPATH)/%$o	 :: %.m
	  $(CC) $(ADD_CFLAGS) $(CFLAGS) $*.c

$(OBJPATH)/%.res :: %.rc
	  rc -i c:\\WATCOM\\h\\os2  -r $*.rc $@



%$x   : %$o
	  ldsh	$(LDFLAGS) $(ADD_OBJS) $(ADD_LDSH_MACROS) OS=$(OS) \
		LIBID=$(LIBID) $*$x $^	$(WKLIB_FULL) $(ADD_LIBS)


%$s   : %$o
	ldsh  $(LDFLAGS) $(LDFLAGS4DLL) $(ADD_LDSH_MACROS) OS=$(OS) \
	      LIBID=$(LIBID) $*$s $^ $(WKLIB4DLL) $(ADD_DLL_LIBS)


#### end of file ####
