/* [logerror.c wk 27.7.90] Error logging to file
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /vol1/src/master/libs/wklib/logerror.c,v 1.6 1995/03/30 12:12:21 wernerk Exp $
 */


#include <wk/tailor.h>
RCSID("$Id: logerror.c,v 1.6 1995/03/30 12:12:21 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include <io.h>
#include <stdarg.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <share.h>
#include <wk/lib.h>
#include <wk/file.h>

/****** constants *********/
#define LOGFILE_NAME "/WK_ERR.LOG"


#ifndef O_BINARY
    #define O_BINARY 0	/* in raw mode only used my MSC */
#endif



/********** types *********/
/********* globals ********/
static char *logFile = NULL;
static char appName[8+1] ;

/**** local prototypes ****/
/****** functions ********/


#ifdef DOCUMENTATION
@Summary LogError
 #include <wk/lib.h>

 void LogError(level,number, text, ... )
 int level;
 ushort number; 	/* bel. Nummer*/
 const char *text;	/* Text mit formatelementen*/
@Description
 Logt eine Error message, der expandierte Text sollte nicht lnger als 512
 bytes werden
 Folgende Level werden untersttzt:
 0 - Info	(I)
 1 - Message	(M)
 2 - Warning	(W)
 3 - Error	(E)
 4 - Critical Error (C)
 5 - Fatal Error    (F)
 Level + 100 : Auch via DebugInfo anzeigen
 Level + 200 : Auch via Error anzeigen
@See Also
 LogErrorInit
@Notes
 Die LogDatei wird jedesmal nur kurz geffnet, wobei mehrere Versuche
 durchgefhrt werden, falls eine ander Station gerade darauf schreiben will
 Sollte ein schreiben auch nach mehrern Versuchen nicht mglich sein
 so wird die Fehlermeldung angezeigt.
#endif /*DOCUMENTATION*/


void LogError( int level, ushort number, const char *strg, ... )
{
    va_list argPtr ;
    char *buf, tBuf1[10], tBuf2[10];
    int n , ch ;
    int hd ;

    va_start( argPtr, strg ) ;
    if( !logFile )
        InitLogError( "?", "." ) ;
    buf = xmalloc(600) ;
    switch( level & 100 ) {
      case 0: ch = 'I' ; break ;
      case 1: ch = 'M' ; break ;
      case 2: ch = 'W' ; break ;
      case 3: ch = 'E' ; break ;
      case 4: ch = 'C' ; break ;
      case 5: ch = 'F' ; break ;
      default: ch = '?' ; break ;
    }
    level /= 100 ;
    n = sprintf( buf, "%s%s%s%05u%c: ", jd2str(-1L,tBuf1,101),
					jd2str(-1L,tBuf2,110),
					appName, number, ch ) ;
    vsprintf( buf+n, strg, argPtr );
    /** remove possible linefead at end of strg */
    for( n=strlen(buf)-1; n > 1 && buf[n] == '\n' ; n-- )
        buf[n] = '\0' ;

    va_end(argPtr);
    for(n=0;n < 10; n++ ) /* try open file with some retries*/
	if( (hd=sopen( logFile, O_BINARY|O_WRONLY|O_CREAT,
				    SH_DENYWR,S_IWRITE|S_IREAD )) == -1 ) {
	    if( errno == EACCES )
		Sleep(50L+rand()%250);	 /* wait 50 .. 300 ms*/
	    else
		break ;
	}
	else {
	    if( lseek( hd, 0L, SEEK_END ) == -1L ) {
		close( hd );
		hd = -1 ;
	    }
	    break;
	}

    if( hd == -1 ) {
	error(1000,GetStr(1), logFile );
	if( level != 2 )
	    level = 2 ;
    }
    else {
	write( hd, buf, strlen(buf) ) ;
        write( hd, "\r\n", 2 ) ;
	close(hd);
    }

    if( level == 1 )
	DebugInfo( buf ) ;
    else if( level == 2 )
	error(0,buf) ;

    free(buf) ;
}


#ifdef DOCUMENTATION
@Summary InitLogError
 #include <wk/wklib.h>

 void InitLogError( app, dir )
 const char *app;	/* Name der Anwendung (max 8 stellen)*/
 const char *dir;	/* Directory fr Logfile*/
@Description
 Initialisiert LogError(), es wird der Anwendungsname angegeben
 und ein Directory, in dem Der Logfile zu schreiben ist, dieser hat
 immer den Namen: WK_ERR.LOG. Dieses Directory kann relativ
 angegeben werden, es wird aber intern in ein absolutes umgewandelt, so
 das auch nach einem Laufwerk-/Directory-wechsel imm er noch an den
 gleichen Logfile geschrieben wird.
@Notes
 Ist diese Funktion noch nicht aufgerufen worden, so wird der Logfile
 im aktuellen  Directory geschrieben.
#endif /*DOCUMENTATION*/

void InitLogError( const char *app, const char *directory )
{
    char orgDir[F_MAX_PATH] ;

    if( !logFile )
	logFile = xmalloc( F_MAX_PATH );

    memset( appName, '*', DIM(appName)-1 );
    appName[DIM(appName)-1] = '\0' ;
    memcpy( appName, app, min( DIM(appName), strlen(app)) );

    strcpy( logFile, directory ) ;
    strcat( logFile, LOGFILE_NAME ) ;
    filename_mkabs( getcwd(orgDir,DIM(orgDir)), logFile );
}

/*** bottom of file ***/
