/* [mt-sup1.c wk 23.01.96] internal multi thread support
 *	Copyright (c) 1988-96 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <wk/tailor.h>
RCSID("$Id: mt-sup1.c,v 1.1 1996/02/27 10:10:39 wernerk Exp $")
#ifdef MULTI_THREADED

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <wk/lib.h>
#if defined(OS20)
    #define INCL_NOCOMMON 1
    #define INCL_DOSSEMAPHORES 1
    #include <os2.h>
#endif

static const char fail1[] =
	    "\nFatal: error creating internal serialize semaphore\n";
static const char fail2[] =
	    "\nFatal: error requesting internal serialize semaphore\n";
static const char fail3[] =
	    "\nFatal: error releasing internal serialize semaphore\n";

#ifdef OS20

/****************
 * level: 1 := Begin Serialize
 *	  0 := End Serialize
 * Note: HMTX is a ulong.
 */
void
wklib_serialize(int level, ulong *semap)
{
    if( !*semap ) {
	/* not yet initialized */
	if( DosCreateMutexSem( NULL, semap , 0, 0 ) || !*semap ) {
	    fputs(fail1, stderr); fflush(stderr);
	    fputs(fail1, stdout); fflush(stdout);
	    abort();
	}
    }
    if( level ) {
	if( DosRequestMutexSem( *semap, -1 ) ) {
	    fputs(fail2, stderr); fflush(stderr);
	    fputs(fail2, stdout); fflush(stdout);
	    abort();
	}
    }
    else {
	if( DosReleaseMutexSem( *semap ) ) {
	    fputs(fail3, stderr); fflush(stderr);
	    fputs(fail3, stdout); fflush(stdout);
	    abort();
	}
    }
}

#else /* !OS20 */

void
wklib_serialize(int level, ulong *a)
{
    #error You must write the function for this OS!
}

#endif /* !OS20 */

#endif /* MULTI_THREADED */
/*** bottom of file ***/
