/* [semaphor.c wk 12.12.92]
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * History:
 * 06.05.93 wk	Moved from WAM to general library WKLib
 *		and renamed from WamSemaphore to QuickSemaphore;
 *		added simple MSDOS and OS/2 1.x stubs
 * 21.01.95 wk	serializeSemphore was never created (may be OS/2 2.0
 *              didn't caught this error?)
 */

#include <wk/tailor.h>
RCSID("$Id: semaphor.c,v 1.6 1995/03/08 16:57:33 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#if defined(OS20)
    #define INCL_NOCOMMON 1
    #define INCL_DOSSEMAPHORES 1
    #define INCL_DOSERRORS 1
    #include <os2.h>
#endif


#include <wk/sema.h>

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

#if OS20
static HMTX serializeSemaphore; /* for internal use */
#endif

/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

#if OS20
static void RequestSerialization(void);
static void ReleaseSerialization(void);
#endif

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

#if OS20

static void RequestSerialization(void)
{
    int rc;
    if( !serializeSemaphore ) {
	if( rc = DosCreateMutexSem( NULL, &serializeSemaphore , 0, FALSE ) )
            Error(4,"Error creating serialize semaphore: rc=%d", rc );
	if( !serializeSemaphore )
	    BUG();
    }
    if( (rc = DosRequestMutexSem( serializeSemaphore , 1000 )) )
        Error(4,"Error requesting internal serialization: rc=%d", rc );
}

static void ReleaseSerialization(void)
{
    int rc;
    if( (rc = DosReleaseMutexSem( serializeSemaphore )) )
        Error(4,"Error releasing internal serialization: rc=%d", rc );
}
#endif

/**************************************************
 *************	Global Functions  *****************
 **************************************************/


#ifdef DOCUMENTATION
@Summary QuickSemaphore RAM Semaphore functions
 #include <wk/sema.h>

 int QuickSemaphore( quickSemaphore_t *mark, int opCode, ulong timeout );
@Description
 Dies ist eine Mehrzweckfunktion, die nur ueber die Macros:
	DCL_SERIALIZE(a);	/* Hilfsvariable a definieren */
	BEGIN_SERIALIZE(a);	/* Beginn des serialisierten Zugriffs */
	BEGIN_SERIALIZE2(a,t);	/* dito, mit timeout Angabe */
	END_SERIALIZE(a);	/* Ende des serialisierten Zugriffs */

	RESET_SEMAPHORE(a);
	POST_SEMAPHORE(a);
	WAIT_SEMAPHORE(a);
	WAIT_SEMAPHORE2(a,t);
 benutzt werden soll.
 "mark" ist das Semaphore.
 "opCode" kann sein:
    1 = Request Mutex Semaphore
    2 = Release Mutex Semaphore
    3 = Reset Event Semaphore
    4 = Post Event Semaphore
    5 = Wait Event Semaphore
 "timeout" kann folgende Werte haben (bei opCode 1 und 5):
    0 = es wird nicht gewartet
    n = es wird n Millisekunden gewartet
    -1L = (0xffffffff) es wird beliebig lange gewartet.
@Return Value
 0 = Okay
 ESEMA_TIMEOUT = Timeout aufgetreten
@Notes
 Es kann nur der Timeout-Fehler auftrtetn, da andernfalls die Anwendung
 mit einem schweren Fehler abgebrochen wird.
 z.Z. nur fuer OS/2 2.x implementiert; stubs fuer andere OSs
#endif /*DOCUMENTATION*/

#if OS20
int QuickSemaphore( quickSemaphore_t *sem, int opCode, ulong timeout )
{
    int rc;
    ulong dummy;

    switch( opCode ) {
      case 1: /* request mutex semaphore */
	/* first check wether we have to create the semaphore */
	if( !*sem ) { /* once again, but protected by a semaphore */
	    RequestSerialization();
	    if( !*sem ) {
		if( rc = DosCreateMutexSem( NULL, sem, 0, FALSE ) )
                    Error(4,"Error creating semaphore: rc=%d", rc );
		if( !*sem )  /* need this for automatic semaphore creation */
                    Bug("Semaphore with handle 0 has been created");
	    }
	    ReleaseSerialization();
	}
	/*  ... and request it */
	if( rc = DosRequestMutexSem( *sem , timeout ) )
	    if( rc == ERROR_TIMEOUT && timeout != -1L )
		return ESEMA_TIMEOUT;
	    else
                Error(4,"Error requesting semaphore: rc=%d", rc );
	break;

      case 2: /* release mutex semaphore */
	if( rc = DosReleaseMutexSem( *sem ) )
            Error(4,"Error releasing semaphore: rc=%d", rc );
	break;

      case 3: /* reset event semaphore */
	/* first check wether we have to create the semaphore */
	if( !*sem ) { /* once again, but protected by a semaphore */
	    RequestSerialization();
	    if( !*sem ) {
		if( rc = DosCreateEventSem( NULL, sem, 0, TRUE ) )
                    Error(4,"Error creating event semaphore: rc=%d", rc );
		if( !*sem )  /* need this for automatic semaphore creation */
                    Bug("EventSemaphore with handle 0 has been created");
	    }
	    ReleaseSerialization();
	}
	/*  ... and reset it */
	if( rc = DosResetEventSem( *sem , &dummy ) )
            Error(4,"Error resetting semaphore: rc=%d", rc );
	break;

      case 4: /* post event semaphore */
	if( !*sem )
            Bug("Attempt to post an not created semaphore");
	if( rc = DosPostEventSem( *sem ) )
	    if( rc != 299 ) /* 299 = already posted */
                Error(4,"Error posting semaphore: rc=%d", rc );
	break;

      case 5: /* wait event semaphore */
	/* first check wether we have to create the semaphore */
	if( !*sem ) { /* once again, but protected by a semaphore */
	    RequestSerialization();
	    if( !*sem ) {
		if( rc = DosCreateEventSem( NULL, sem, 0, TRUE ) )
                    Error(4,"Error creating event semaphore: rc=%d", rc );
		if( !*sem )  /* need this for automatic semaphore creation */
                    Bug("EventSemaphore with handle 0 has been created");
	    }
	    ReleaseSerialization();
	}
	/*  ... and wait */
	if( rc = DosWaitEventSem( *sem , timeout ) )
	    if( rc == ERROR_TIMEOUT && timeout != -1L )
		return ESEMA_TIMEOUT;
	    else
                Error(4,"Error waiting for semaphore: rc=%d", rc );
	break;


      default: BUG(); /*NOTREACHED*/
    }
    return 0;
}
#else /* stub fuer unbekannte OS */

int QuickSemaphore( quickSemaphore_t *sem, int opCode, ulong timeout )
{
    switch( opCode ) {
      case 1: /* request mutex semaphore */
	break;

      case 2: /* release mutex semaphore */
	break;

      case 3: /* reset event semaphore */
	break;

      case 4: /* post event semaphore */
	break;

      case 5: /* wait event semaphore */
	break;

      default: BUG(); /*NOTREACHED*/
    }
    return 0;
}
#endif

/**** end of file ****/
