/* [srchcmd.c wk 12.4.89] Search for a shell command
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <wk/tailor.h>
RCSID("$Id: srchcmd.c,v 1.7 1995/03/08 16:57:36 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/io.h>
#include <wk/environ.h>
#include <wk/file.h>
#include <wk/string.h>


#ifdef DOCUMENTATION
@Summary SearchCommand	   Search for a DOS command
 #include <wk/environ.h>

 int SearchCommand( command );
 char command[F_MAX_PATH] ;  Name des Kommandos
			     Returns: Pfad des Kommandos

@Description
 Sucht nach dem vollen Pfadnamen oder nach internem Kommando
 Dabei die bliche DOS Suchreihenfolge einhalten:
@Return Value
 0 - nicht gefunden
 1 - internes Kommando
 2 - .COM File
 3 - .EXE File
 4 - .BAT/.CMD File ( je nach OS )
#endif


int SearchCommand( char *pgm )
{
    int ft ;
  #ifdef UNIX
    register int i;
    char *buf;

    ft = 0;
    if( !(buf = malloc( F_MAX_PATH )) )
	return 0 ;
    i = strlen( pgm );
    *buf = '\0' ;
    if( FileDrvCheck( pgm ) ) {
	if( !access( pgm, 00 ) )
	    strcpy( buf, pgm ) ;
    }
    else
        SearchEnv( pgm, "PATH", buf );
    if( *buf ) {
	strcpy( pgm, buf ) ;
	ft = 3;
    }
    free( buf ) ;
  #else
    register int i , j ;
  #ifdef OS2
    static char *ext[] = { ".exe", ".cmd", NULL } ;
    static char *cmds[] =
            {   "dir", "call", "chcp", "rename", "ren", "erase", "del",
                "type", "rem", "copy", "pause", "date", "time", "ver",
                "vol", "cd", "chdir", "md", "mkdir", "rd", "rmdir",
                "break", "verify", "set", "prompt", "path", "exit",
                "ctty", "echo", "goto", "shift", "if", "for", "cls" ,
                "start", "detach", "setlocal", "endlocal", "dpath",
		NULL
	     } ;
  #else
    static char *ext[] = { ".com", ".exe", ".bat", NULL } ;
    static char *cmds[] =
            {   "dir", "call", "chcp", "rename", "ren", "erase", "del",
                "type", "rem", "copy", "pause", "date", "time", "ver",
                "vol", "cd", "chdir", "md", "mkdir", "rd", "rmdir",
                "break", "verify", "set", "prompt", "path", "exit",
                "ctty", "echo", "goto", "shift", "if", "for", "cls" ,
		NULL
	     } ;
  #endif

    ft = 0 ;
    for( i = 0 ; cmds[i] ; i++ )
	if( !strcmpl( pgm, cmds[i] ) )
	{
	    ft = 1 ;   /* intrinsic command found */
	    strcpy( pgm, cmds[i] ) ;
	    break ;
	}
    if( !ft ) {
	char  *buf ;

	if( !(buf = malloc( F_MAX_PATH )) )
	    return 0 ;
	i = strlen( pgm ) - 4 ;
        if( !(i > 0 && pgm[i] == '.') )
	    i += 4 ;
	for( j=0 ; ext[j] ; j++ ) {
	    strcpy( pgm+i, ext[j] ) ;
            *buf = '\0' ;
	    if( FileDrvCheck( pgm ) ) {
		if( !access( pgm, 00 ) )
		    strcpy( buf, pgm ) ;
	    }
	    else
                SearchEnv( pgm, "PATH", buf ) ; /* funktioniert nicht mit*/
						/* Laufwerksangabe*/
	    if( *buf ) {
		strcpy( pgm, buf ) ;
		ft = j+2 ;
		break ;
	    }
	}
	free( buf ) ;
    }
  #endif /* not UNIX */
    return ft ;
}




#ifdef TEST

void main(int argc, char **argv )
{
    int res ;
    char pgm[F_MAX_PATH] ;

    if( argc > 1 ) {
	argv++ ;
	strcpy( pgm , *argv ) ;

        printf( "Searching for `%s' ...", pgm );
	res = search_command( pgm );
        printf( "\b\b\b\nFound '%s' (%d)\n", pgm, res ) ;

    }
    exit(0) ;
}

#endif

/*** bottom of file ***/
