/* [strg1.c wk 25.4.89]  mem2str()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 26.05.92 wk	Changed while-loop to for-loop, because there was no
 *		check for end of source-string; caused trap on
 *		OS/2 under some circumstances
 * 20.04.95 wk	Added readonly logic to IdentStr(), because linux (1.2.4)
 *		seams to makes the segment with readonly strings read-only;
 *		so this caused a segment violation.
 */

#include <wk/tailor.h>
RCSID("$Id: strg1.c,v 1.8 1995/04/20 20:50:49 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <wk/string.h>

#ifdef __GNUC__
  #define READONLY_STRINGS 1
#endif


#ifdef READONLY_STRINGS

struct identlist {
    struct identlist *next;
    const void *orig;  /* the read-only string */
    char d[1];	       /* and the replacement */
};

typedef struct identlist *IDENTLIST;

static IDENTLIST identlist;

static void
Cleanup(void)
{
    IDENTLIST x, x2;

    for(x=identlist; x; x = x2 ) {
	x2 = x->next;
	free(x2);
    }
    identlist = NULL;
}

#endif



#ifdef DOCUMENTATION
@Summary mem2str	   Copy buffer to string
 #include <wk/string.h>

 char *mem2str( d, s, n );
 char	*d ;		Destination
 const void *s ;	Buffer
 size_t n ;		Length of Destination buffer

@Description
 Wie strncpy(), aber es werden maximal n-1 zeichen kopiert und ein
 '\0' angehngt. Ist n = 0, so geschieht nichts, ist Destination
 gleich NULL, so wird via malloc Speicher besorgt, ist dann nicht
 gengend Speicher vorhanden, so bricht die funktion ab ( xmalloc() )

@Return Value
 destination

@See Also
 strncpy
#endif


#if __MSC__
#pragma check_stack(off)
#endif

char *mem2str( char *dest , const void *src , size_t n )
{
    register char *d , *s ;

    if( n ) {
	if( !dest )
	    dest = xmalloc( n ) ;
	d = dest ;
	s = (char*)src ;
	for(n--; n && *s; n-- )
	    *(d++) = *(s++) ;
	*d = '\0' ;
    }

    return dest ;
}



#ifdef DOCUMENTATION
@Summary IdentStr
 #include <wk/string.h>

 char *IdentStr( char *identstr );
@Description
 Diese Funktion ersetzt das Ident-Ende-Zeichen ($) durch ein Stringende
 und gibt einen Zeiger auf das erste Element des Wertes zurueck; falls
 kein Stringende Zeichen mehr da ist, wird nur der zeiger zuruckgegeben.
 Falls Strings nicht beschreibbar sind, wird hier eine Kopie angelegt.
 Das erste Zeichen muss ein Dollar-Zeichen sein - ansonsten wird
 der String unveraendert zurueckgegeben.
 Wird eine Kopie zurckgegeben, so wird das fr den angegebenen String nur
 einmalig gemacht (und auch keine Kopie fr eine Kopie zurckgegeben)
@Return Value
 Ptr in identstr (Dies kann aber auch eine Kopie sein)
@Example
 /* (Das $ is durch ein ! ersetzt, damit RCS hier nichts ersetzt) */
 printf( "Revision=%s", IdentStr("!Revision: 1.2!");
 /* gibt aus: "Revision=1.2" */
#endif /*DOCUMENTATION*/

char *IdentStr( char *string )
{
    char *s;
    if( *string != '$' )
	return string;
    for( s= string+1; *s && *s != ':'; s++ )
	;
    if( !*s )
	return string;
    for(s++ ; isspace(*(byte*)s) ; s++)
	;
    string = s;
    for(s=string; *s ; s++ )
	if( *s == '$' && isspace(s[-1]&0xff) ) {
	  #ifdef READONLY_STRINGS
	    IDENTLIST x;

	    if( !identlist )
		RegisterCleanup( Cleanup );
	    for(x=identlist; x; x = x->next )
		if( x->orig == string )
		    return x->d;
	    x = xmalloc( sizeof *x + strlen(string) -1 );
	    mem2str(x->d, string, s - string );
	    x->orig = string;
	    x->next = identlist;
	    identlist = x;
	    return x->d;
	  #else
	    s[-1] = 0;
	    break;
	  #endif
	}
    return string;
}




/***** bottom of file ******/
