/* [strg2.c wk 21.9.90] StripWSpaces()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History;
 * 27.02.93 wk	new function AreWSpaces()
 * 04.03.93 wk	new funcions Strip(Leading/Trailing)WSpaces.
 *		removed bug in StripWSpaces(): returned wrong ptr
 *		when leading spaces where removed
 */

#include <wk/tailor.h>
RCSID("$Id: strg2.c,v 1.5 1995/03/08 16:57:49 wk Exp $")
#include <stdio.h>
#include <ctype.h>
#include <wk/string.h>


#ifdef DOCUMENTATION
@Summary StripWSpaces	Strip White Spaces from String
 #include <wk/string.h>

 char *StripWSpaces( a )
 char *a;
@Description
 Diese Funktion entfernt von dem angegebenen String alle White Spaces am
 Anfang und am Ende.
@Return Value
 string
#endif /*DOCUMENTATION*/


char *StripWSpaces( char *str )
{
    register char *string;
    register char *p ;
    register char *mark ;

    string = str;
    /* find first non space character */
    for( p=string; *p && isspace( *(byte*)p ) ; p++ )
	;
    /* move charcters */
    for( (mark = NULL); (*string = *p); string++, p++ )
	if( isspace( *(byte*)p ) ) {
	    if( !mark )
		mark = string ;
	}
	else
	    mark = NULL ;
    if( mark )
        *mark = '\0' ;  /* remove trailing spaces */

    return str ;
}


#ifdef DOCUMENTATION
@Summary AreWSpaces   Tests String for White Spaces
 #include <wk/string.h>

 int AreWSpaces( const char *s )
@Description
 Diese Funktion testet, ob ein string nur aus White Spaces besteht.
@Return Value
 True wenn der String nur white spaces enthaelt
#endif /*DOCUMENTATION*/


int AreWSpaces( register const char *p )
{
    for( ; *p && isspace( *(const byte*)p ) ; p++ )
	;
    return !*p;
}


#ifdef DOCUMENTATION
@Summary StripLeadingWSpaces   Strip Leading White Spaces from String
 #include <wk/string.h>

 char *StripLeadingWSpaces( a )
 char *a;
@Description
 Diese Funktion entfernt von dem angegebenen String alle White Spaces am
 Anfang.
@Return Value
 string
#endif /*DOCUMENTATION*/


char *StripLeadingWSpaces( char *str )
{
    register char *string;
    register char *p ;

    string = str;
    /* find first non space character */
    for( p=string; *p && isspace( *(byte*)p ) ; p++ )
	;
    if( p != string ) /* move characters */
	for( ; (*string = *p); string++, p++ )
	    ;
    return str ;
}



#ifdef DOCUMENTATION
@Summary StripTrailingWSpaces	Strip Trailing White Spaces from String
 #include <wk/string.h>

 char *StripTrailingWSpaces( a )
 char *a;
@Description
 Diese Funktion entfernt von dem angegebenen String alle White Spaces am
 Ende.
@Return Value
 string
#endif /*DOCUMENTATION*/


char *StripTrailingWSpaces( char *str )
{
    register char *p ;
    register char *mark ;

    /* find last non space character */
    for( mark = NULL, p = str; *p; p++ )
	if( isspace( *(byte*)p ) ) {
	    if( !mark )
		mark = p ;
	}
	else
	    mark = NULL ;
    if( mark )
        *mark = '\0' ;  /* remove trailing spaces */

    return str ;
}





/******************** bottom of file ***************************/
