/* [strg3.c wk 28.9.90] nstrtok()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/libs/wklib/strg3.c,v 1.6 1996/08/12 16:55:44 wk Exp $
 */

#include <wk/tailor.h>
RCSID("$Id: strg3.c,v 1.6 1996/08/12 16:55:44 wk Exp $")
#include <stdio.h>
#include <ctype.h>
#include <wk/string.h>


#ifdef DOCUMENTATION
@Summary nstrtok   Like strtok, but reentrant
 #include <wk/strhilf.h>

 char *nstrtok( string, control, help )
 char *string;	    /*aufzuspaltender String, bzw NULL*/
 char *control;     /*String mit den delimitern*/
 char **help;	    /* hilfsvariable*/
@Description
 Wie Standard Funktion strtok, aber reentrant durch hilfsvariable
@Return Value
 next token
#endif /*DOCUMENTATION*/


char *nstrtok( char *string , char *control, char **nextToken )
{
    byte map[32];
    char *token ;
    int i;

    if( !string )
	string = *nextToken ;

    /* store control characters in a Bitmap */
    for(i=0; i < sizeof map ; i++)
	map[i] = 0;
    do {   /* '\0' is also a control charcter, so use do while*/
	map[*control >> 3] |= (1 << (*control & 7));
    } while( *control++ );

    while( map[*string >> 3] & (1 << (*string & 7)) && *string )
	string++;

    for(token = string ;; string++) {
	if( map[*string >> 3] & (1 << (*string & 7)) ) {
	    if( !*string && string == token )
		return NULL;
	    if( *string )
                *string++ = '\0';
	    *nextToken = string;
	    return token ;
	}
    }
}

/******************** bottom of file ***************************/
