/* [strg4.c wk 25.5.91] StrNShift() stristr() StrNRepl()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <wk/tailor.h>
RCSID("$Id: strg4.c,v 1.7 1995/03/08 16:57:56 wk Exp $")
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <wk/string.h>


#ifdef DOCUMENTATION
@Summary StrNShift	   Shift characters in a string
 #include <wk/string.h>

 char *StrNShift( p , i , n );
 char	*p ;		String
 int	i ;		Verschiebefaktor
 unsigned n ;		max. Lnge des Strings
@Description
 Die Funktion strnshift verschiebt Bytes in einem String; falls i < 0 :
 es werden i Bytes am Anfang entfernt.	falls i > 0 :  es werden i Blanks
 am Anfang eingeschoben.  Wird der String zu lang, so wird er auf n Bytes
 abgeschnitten.
@Return Value
 Pointer to String
#endif

#if __MSC__
#pragma check_stack(off)
#endif

char *StrNShift( char *p , int i, unsigned n )
{
    register char *s ;
    unsigned len ;

    if( i < 0 ) {
	i = - i ;
	for( s = p ; *s && s[i] ; s++ )
	    *s = s[i] ;
        *s = '\0' ;
    }
    else if( i > 0 ) {
	if( (len=strlen(p)) > n-i )
            p[len=(n-i)] = '\0' ;
	for( s = p + len ; s >= p ; s-- )
	    s[i] = *s ;
	for( s += i ; s >= p ; s-- )
            *s = ' ' ;
    }

    return p ;
}


#ifdef DOCUMENTATION
@Summary stristr	  Find substring, case insensitive
 #include <wk/string.h>

 char *stristr( string, sub );
 const char   *string ;       String to search
 const char   *sub ;	      Substring to search for
@Description
 Same as strstr() but search is regardless of case.
@Return Value
 A pointer to the first occurrence of sub in string
 or NULL if sub not found.
#endif

#if __MSC__
#pragma check_stack(off)
#endif

char *stristr( const char *text, const char *sub )
{
    register const char  *t, *s ;

    for( t = text, s = sub ; *t ; t++ )
	if( toupper(*t) == toupper(*s) ) {
	    for( text = t++, s++ ; *t && toupper(*t) == toupper(*s); t++, s++ )
		;
	    if( !*s )
		return (char*)text ; /* ist nach ANSI richtig, aber warum ? */
	    t = text ; s = sub ;
	}

    return NULL ;
}


/*
 * in 'text' werden am anfang 'len' bytes durch 'sub' ersetzt
 * 'n' gibt dabei die maximale lnge von 'text' an;
 * wird 'text' zu lang, so wird er abgeschnitten.
 * returns: ptr auf 'text'.
 */
#ifdef DOCUMENTATION
@Summary StrNRepl	  Replace a substring
 #include <wk/string.h>

 char *StrNRepl( p , s , l , n );
 char	*p ;		String
 char	*s		Replacestring
 unsigned l		Lnge des zu ersetzenden Teilstrings
 unsigned n ;		Max. Lnge des Strings
@Description
 Diese Funktion ersetzt die ersten l Bytes in String p durch den String s.
 Der String p wird entsprechend aufgeschoben bzw.  zusammengeschoben.
 Wird p zu lang, so wird er nach der Ersetzung auf n Bytes abgeschnitten.
@Return Value
 A Pointer to String
@Example
 #include <wk/string.h>

 char string[100] ;
 .
 .
 /*
  * ersetze die ersten 3 bytes durch "12345"
  */

 strcpy( string, "ein test string" ) ;
 strnrepl( string, "12345", 3, 100 ) ;

 /*
  *  string = "12345 test string"
  */

#endif


char *StrNRepl( char *text, const char *wert, unsigned len, unsigned  n )
{
    register char *s ;

    StrNShift( text , strlen( wert ) - len , n ) ;
    for( s = text ; *wert ; s++, wert++)
	*s = *wert ;

    return text ;
}


/******** bottom of file ***********/
