/* [strg6.c wk 4.6.92] ANSISupportfunctions
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 05.03.93 wk	stpcpy() fuer IBM CSet
 */

#include <wk/tailor.h>
RCSID("$Id: strg6.c,v 1.12 1996/08/28 13:21:35 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/string.h>



int StrICmp( const char *a, const char *b )
{


    for( ; *a && *b; a++, b++ )
	if( *a != *b )
	    if( toupper(*a) != toupper(*b) )
		return *a - *b;
    return *a - *b;
}


int MemICmp( const char *a, const char *b, size_t n )
{

    for( ; n; n--, a++, b++ )
	if( *a != *b )
	    if( toupper(*a) != toupper(*b) )
		return *a - *b;
    return 0;
}


#if __STDC__ && !__WATCOMC__

char *ltoa(long i, char *a, int base)
{
    unsigned long u;
    char buf[ sizeof(long) * 8 + 1];
    char *p;
    char *q = a;
    int n;

    u = i;
    buf[sizeof(buf) - 1] = 0;
    p = &buf[sizeof(buf) - 2];		/* last character position	*/
    if (10 == base && (long) u < 0) {
	*q++ = '-';
	u = -u;
    }
    for(;;) {
	n   = u % base;
	if( n < 10 )
	    *p = n + '0';
	else switch( n ) {
	  case 10: *p = 'A'; break;
	  case 11: *p = 'B'; break;
	  case 12: *p = 'C'; break;
	  case 13: *p = 'D'; break;
	  case 14: *p = 'E'; break;
	  case 15: *p = 'F'; break;
	  case 16: *p = 'G'; break;
	  case 17: *p = 'H'; break;
	  case 18: *p = 'I'; break;
	  case 19: *p = 'J'; break;
	  case 20: *p = 'K'; break;
	  case 21: *p = 'L'; break;
	  case 22: *p = 'M'; break;
	  case 23: *p = 'N'; break;
	  case 24: *p = 'O'; break;
	  case 25: *p = 'P'; break;
	  case 26: *p = 'Q'; break;
	  case 27: *p = 'R'; break;
	  case 28: *p = 'S'; break;
	  case 29: *p = 'T'; break;
	  case 30: *p = 'U'; break;
	  case 31: *p = 'V'; break;
	  case 32: *p = 'W'; break;
	  case 33: *p = 'X'; break;
	  case 34: *p = 'Y'; break;
	  case 35: *p = 'Z'; break;
	  default: *p = '?'; break;
	}
	if ((u /= base) == 0)
	    break;
	p--;
    }
    memcpy(q, p, &buf[sizeof(buf)] - p);
    return a;
}

#endif



#if __IBMC__ || __MSC__ || __WATCOMC__ || __DECC || (HPUX && !__GNUC__)
char *stpcpy(char *a,const char *b)
{
    while( *b )
	*a++ = *b++;
    *a = 0;

    return (char*)a;
}
#endif

/****************
 * Only compare up to n characters (case insensitive)
 * same functions as BSD strncasecmp
 */

int
strnicmp( const char *a, const char *b, size_t n )
{
    for( ; n && *a && *b; a++, b++, n-- )
	if( *a != *b )
	    if( toupper(*a) != toupper(*b) )
		return *a - *b;

    return n? (*a - *b) : 0;
}

/***** bottom of file ******/
