/* [strg8.c wk 13.07.93] Simple Text buffer handler
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 05.08.93 wk	Buffercheck and new structure layout
 * 14.10.94 wk	Added  AppStrgbuf()
 */

#include <wk/tailor.h>
RCSID("$Id: strg8.c,v 1.6 1995/11/30 13:13:22 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>  /* decc needs it */
#include <wk/strgbuf.h>

#define MAGIC_VALUE 0x3765
static void MagicCheck( strgbuf_t *a );


strgbuf_t *
AllocStrgbuf( size_t initial )
{
    strgbuf_t *buf;

    if( !initial )
	initial = 8192;
    buf = xmalloc( sizeof *buf );
    buf->p = xmalloc( initial +1 );
    buf->p[0] = 0; /* set first byte to zero */
    buf->siz = initial;
    buf->chunk = initial;
    buf->len = 0;
    buf->rptr = 0;
    buf->reserved = MAGIC_VALUE;
    buf->savelen = 0;
    buf->arr = NULL;
    return buf;
}


void
GrowStrgbuf( strgbuf_t *a )
{
    MagicCheck(a);
    a->siz += a->chunk;
    if( !(a->p = realloc( a->p, a->siz + 1 )) )
        Error(8,"error: out of memory while resizing a strgbuf");
}

void
FreeStrgbuf( strgbuf_t *a )
{
    MagicCheck(a);
    free( a->p );
    free( a->arr );
    free( a );
}


char **
GetStrgbufArray( strgbuf_t *a )
{
    char *p;
    size_t n, i;

    MagicCheck(a);
    if( a->savelen == a->len ) {
	if( !a->arr )
	    a->arr = xcalloc( 1, sizeof *a->arr );
    }
    else { /* meanwhile changed */
	free( a->arr );
	a->savelen = a->len;
	/* count # of strings */
	for(n=i=0, p=a->p ; i < a->len; p++, i++,n++ )
	    for( ; *p && i < a->len; p++, i++ )
		;
	/* allocate array */
	a->arr = xcalloc( n+1, sizeof *a->arr );
	/* setup array */
	for(n=i=0, p=a->p ; i < a->len; p++, i++,n++ ) {
	    a->arr[n] = p;
	    for( ; *p && i < a->len; p++, i++ )
		;
	}
    }
    return a->arr;
}


static void
MagicCheck( strgbuf_t *a )
{
    if( a->reserved != MAGIC_VALUE )
        Bug( "Stringbuffer corruption detected in " __FILE__ );
}



/****************
 * Append a String to the stringbuffer
 */

void
AppStrgbuf( strgbuf_t *a, const char *s )
{
    size_t n = strlen(s);

    while( a->len+n >= a->siz )
	GrowStrgbuf(a);
    memcpy(a->p + a->len, s, n );
    a->len += n;
}


/***** bottom of file ******/
