/* [time3.c wk 03.03.94] More time functions
 *	Copyright (c) 1988-94 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 24.01.95 wk	added GetUTCDateAndTime()
 */

#include <wk/tailor.h>
RCSID("$Id: time3.c,v 1.5 1995/03/08 16:58:29 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <wk/lib.h>



#ifdef DOCUMENTATION
@Summary GetDateAndTime GetUTCDateAndTime
 #include <wk/lib.h>

 long GetDateAndTime( long *rettime );
 long GetUTCDateAndTime( long *rettime );
@Description
 Retrieves the current date and time. date and time are syncronized and
 the value of time may have another granularity than by a call to
 TimeOfDay(). This function should be preferred to get a timestamp.
 If the Argument is the NULL-Pointer, the time will not be retrieved
 but the return-value will be the granularity of this call.
 The Date is represented in Julian Days, time and granulartity are
 represented in milliseconds (since midnight).
 GetUTCDateAndTime() tries to get UTC time.
@Return Value
 The Julian-Date or the granularity of this call.
@See Also
 TimeOfDay() TodaysJD()
#endif /*DOCUMENTATION*/


long GetDateAndTime( long *rettime )
{
    struct tm *t;
    time_t ts ;

    if( rettime ) {
	time( &ts ) ;
	t = localtime( &ts ) ;
	*rettime = (3600L*t->tm_hour + 60L*t->tm_min + t->tm_sec) * 1000L;
	return Date2JD( t->tm_mday, t->tm_mon+1, t->tm_year+1900 ) ;
    }
    return 1000; /* I think this is the granularity, should be finer */
}


long GetUTCDateAndTime( long *rettime )
{
    struct tm *t;
    time_t ts ;

    if( rettime ) {
	time( &ts ) ;
	/* Standard-C allows gmtime to return NULL if the */
	/* timezone is unknown; POSIX systems should always know the TZ */
	if( !(t = gmtime( &ts )) )
	    t = localtime( &ts ) ;
	*rettime = (3600L*t->tm_hour + 60L*t->tm_min + t->tm_sec) * 1000L;
	return Date2JD( t->tm_mday, t->tm_mon+1, t->tm_year+1900 ) ;
    }
    return 1000;
}


/*** bottom of file ****/
