/* [time4.c wk 21.06.94] JD2Str()
 *	Copyright (c) 1988-94 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <wk/tailor.h>
RCSID("$Id: time4.c,v 1.7 1996/06/07 08:06:30 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/lib.h>
#include <wk/string.h>


static char buffer[50];


#ifdef DOCUMENTATION
@summary JD2Str 	   Print a julian date or a time
 #include <wk/lib.h>

 char *JD2Str( jd, mode, buf );
 char *JD2Str2(jd, mode, t, tmode, buf );
 long	jd;	     Julianische Periode/time in millisekunden
 int mode ;
 long t;	     Zeit
 int tmode;	     Zeitmode
 char	*buf;	     Buffer, muss lang genug sein oder NULL

@Description
 Wandelt ein Julianisches Datum in einen String um.
 Ist JD=0, so wird ein leerer String zurckgegeben.
 Ist JD=-1L, so wird das Tagesdatum bzw. die Tageszeit zurckgegeben.
 Bei einem Zeitmodi wird die Zeit in Millisekunden erwartet.
 Der Buffer muss lang genug fr den jeweiligen Modus sein oder NULL sein
 um einen statischen Buffer zu benutzen. Die minimale Lnge des Buffers
 betrgt immer 7 um den Fehlerstring hineikopieren zu knnen..
 Folgende Modi sind implementiert:

     0 -  "TT.MM.JJ"
     1 -  "TT.MM.JJJJ"
     2 -  "T.M.JJ"
     3 -  "T.M.JJJJ"

    14 -  "JJMMTT"
    15 -  "JJJJMMTT"

    20 -  "TT.mon.JJ"
    21 -  "TT.mon.JJJJ"
    22 -  "T. mon JJJJ"
    23 -  "mon JJJJ"
    24 -  "mon.JJ"
    25 -  "mon.JJJJ"
    26 -  "mon TT"

    32 -  "T. monat_lang JJJJ" (buffer: min 25 byte)
    33 -  "monat_lang JJJJ"    (buffer: min 25 byte)

    40 -  "wt. TT.MM.JJ"    (wt = wochentag)
    41 -  "wt. TT.MM.JJJJ"
    42 -  "wt. T. mon JJJJ" (buffer: min 20 byte)
    43 -  "wt. T. monat_lang JJJJ" (buffer: min 25 byte)

   100 -  "HH:MM"
   101 -  "HH:MM:SS"
   102 -  "HH:MM:SS.HH"
   103 -  "HH:MM:SS.HHH"
   110 -  "HHMM"
   111 -  "HHMMSS"
   112 -  "HHMMSSHH"
   113 -  "HHMMSSHHH"

 Wird ein negativer modi benutzt, so werden fr die Strings
 unabhngig von setlocale() immer die englischen Strings benutzt.
 Bei einem fehlerhaften Datum wird in den Buffer der String "?date?"
 geschrieben; 0 ist kein fehlerhaftes Datum sondern gibt einen String
 in der richtigen lnge am nur mit blanks zurueck.
 Jd2Str2() Ist eine kombinierte Funktion um Datum und Zeit in einen String zu
 packen. Datum und Zeit werden durch Blank getrennt hintereinander gehangen,
 wird beidesmal -1 benutz so wird GetDateAndTime() benutzt. Wenn die Modi
 110-119 mit den Modi 10-19 kombiniert werden, so wird kein Blank dazwischen
 eingefgt. Um UTC Time zu erhalten kann hier auch die Kombination (-2,-2)
 angegeben werden.
@Return Value
 Pointer to Buffer
@See Also
 JD2Date
#endif



char *JD2Str( long jd, int mode, char *buf )
{
    int y , m , d , mil;
    char *p ;
    static const char *wt0[] = { "Mo", "Tu", "We", "Th", "Fr", "Sa", "Su" } ;
    static const char *mon0[] = { "January", "February", "March", "April",
		"May", "June", "July", "August", "September",
		"October", "November", "December" }  ;
    static const char *wt1[] = { "Mo", "Di", "Mi", "Do", "Fr", "Sa", "So" } ;
    static const char *mon1[] = { "Januar", "Februar", "Mrz", "April",
		"Mai", "Juni", "Juli", "August", "September",
		"Oktober", "November", "Dezember" }  ;
    const char **wt, **mon;

    if( !buf )
	buf = buffer;
    *buf = '\0' ;
    if( mode < 0 ) {
	mode = - mode;
	mon = mon0;
	wt = wt0;
    }
    else {
	mon = mon1;
	wt = wt1;
    }

    if( mode >= 100 && mode < 200 ) { /* Sonderfall Zeitformate */
	if( !jd )
	    d = 11, m = 11, y = 11, mil=111;
	else {
	    if( jd == -1 )
		jd = TimeOfDay() ;
	    mil = jd % 1000;
	    jd /= 1000 ;    /* convert to seconds*/
	    d = jd / 3600L;	  /* Hours*/
	    m = (jd % 3600L)/60L; /* Minutes*/
	    y = jd % 60L;	  /* Seconds*/
	}
	p = buf;
	*p++ = d > 9 || mode >= 110 ? (d/10)+'0':' ';
	*p++ = d % 10 + '0' ;
	if( mode < 110 )
	    *p++ = ':';
	*p++ = m / 10 + '0';
	*p++ = m % 10 + '0';
	if( mode % 10 ) {
	    if( mode < 110 )
		*p++ = ':';
	    *p++ = y / 10 + '0';
	    *p++ = y % 10 + '0';
	}
	*p = 0;
	if( (mode >= 102 && mode < 110) ||
	    (mode >= 112 && mode < 120) ) {
	    sprintf(p, mode < 110 ? ".%03d":"%03d", mil );
	    if( mode % 10 == 2 )
		p[strlen(p)-1] = 0;
	}
    }
    else { /* Datumsformate*/
	if( !jd )
	    d = 11, m = 11, y = 1911;
	else {
	    if( jd == -1 )
		jd = TodaysJD() ;
	    if( !JD2Date( jd, &d, &m, &y ) )
		return strcpy(buf,"?date?");
	}

	p = buf;
	if( mode >= 40 && mode < 50 ) {
	    p = stpcpy( p, wt[ jd % 7 ] ) ;
	    p = stpcpy( p, ". " ) ;
	}
	switch( mode ) {
	  case 2: /* T.M.JJ */
	    sprintf( p, "%d.%d.%02d", d, m, y % 100 ) ;
	    break;
	  case 3: /* T.M.JJJJ */
	    sprintf( p, "%d.%d.%04d", d, m, y ) ;
	    break;

	  case 0:  /* TT.MM.JJ */
	  case 40: /* wt. TT.MM.JJ */
	    sprintf( p, "%2d.%02d.%02d", d, m, y % 100 ) ;
	    break;

	  case 14: /* JJMMTT */
	    sprintf( p, "%02d%02d%02d", y % 100, m, d ) ;
	    break;

	  case 15: /* JJJJMMTT */
	    sprintf( p, "%04d%02d%02d", y, m, d ) ;
	    break;

	  case 20: /* TT.mon.JJ */
	    sprintf( p, "%2d.%.3s.%02d", d, mon[m-1], y % 100) ;
	    break;
	  case 21: /* TT.mon.JJJJ */
	    sprintf( p, "%2d.%.3s.%04d", d, mon[m-1], y ) ;
	    break;
	  case 22: /* T. mon JJJJ */
	  case 42: /* wt. T. mon JJJJ */
	    sprintf( p, "%d. %.3s %4d", d, mon[m-1], y ) ;
	    break;

	  case 23: /* mon JJJJ */
	    sprintf( p, "%.3s %4d", mon[m-1], y ) ;
	    break;

	  case 24: /* mon.JJ */
	    sprintf( p, "%.3s.%02d", mon[m-1], y%100 ) ;
	    break;
	  case 25: /* mon.JJJJ */
	    sprintf( p, "%.3s.%04d", mon[m-1], y ) ;
	    break;
	  case 26: /* mon DD */
	    sprintf( p, "%.3s %02d", mon[m-1], d ) ;
	    break;
	  case 32: /* T. monat_lang JJJJ */
	  case 43: /* wt. T. monat_lang JJJJ */
	    sprintf( p, "%d. %s %4d", d, mon[m-1], y ) ;
	    break;

	  case 33: /* monat_lang JJJJ */
	    sprintf( p, "%s %4d", mon[m-1], y ) ;
	    break;

	  case 1:  /* TT.MM.JJJJ */
	  case 41: /* wt. TT.MM.JJJJ */
	  default:
	    sprintf( p, "%2d.%02d.%04d", d, m, y ) ;
	    break;
	}
    }
    if( !jd )
	strset(buf,' ');
    return buf ;
}


char *JD2Str2( long jd, int dmode, long t, int tmode, char *buf )
{
    int a,b;

    if( !buf )
	buf = buffer;

    if( jd==-1 && t==-1 ) /* get date and time syncronized */
	jd = GetDateAndTime( &t );
    else if( jd==-2 && t==-2 ) /* get UTC date and time syncronized */
	jd = GetUTCDateAndTime( &t );

    if( tmode < 100 || tmode > 199 )
	tmode = 100;  /* damit der Buffer nicht zu klein ist */
    JD2Str( jd, dmode, buf );

    a = dmode < 0 ? -dmode: dmode;
    b = tmode < 0 ? -tmode: tmode;
    if( !(a >= 10 && a < 20 && b >= 110 && b < 120) )
	strcat(buf," ");

    JD2Str( t, tmode, buf+strlen(buf) );
    return buf;
}

/*** bottom of file ****/
