/* [time6.c wk 09.02.95] Str2Time
 *	Copyright (c) 1988-95 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <wk/tailor.h>
RCSID("$Id: time6.c,v 1.3 1995/11/30 13:13:24 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/string.h>


#ifdef DOCUMENTATION
@summary Str2Time	 Scan a time string
 #include <wk/lib.h>

 int Str2Time( string, ret_tm, ret_n );
 const char *string; String mit Zeitangabe
 long  *ret_jd;      wenn != NULL: Millisekunden seit Mitternacht
 size_t *ret_n;      wenn != NULL: Lnge des betrachteten Zeit-Strings
@Description
 Wandelt einen String in eine Zeitangabe um, White-Spaces am Anfang
 werden bersprungen, die Zeit wird im Format hh:mm[:ss[.hhh]] erwartet.
 Optionale Angaben werden durch Stringende oder einZeichen ungleich dem
 Doppelpunkt bzw. dem Punkt erkannt.
 ret_n wird auch im fehlerfall gesetzt.
@Return Value
 0 ist ein gltige Zeit
 1 := Fehler in der Stunde
 2 := Fehler in der Minute
 3 := Fehler in der Sekunde
 4 := Fehler in der Tausendstel Sekunde
@See Also
 Str2JD
#endif


int Str2Time( const char *string, long *ret_tm, size_t *ret_n )
{
    int hh,mm,ss,tau;
    const char *s;
    size_t n=0;
    int rc=0;

    if( ret_n )
	*ret_n = 0;
    ss = tau = 0;
    s = string;
    while( isspace(*s) )
	s++, n++;

    if( !isdigit(*s) )
	{ rc = 1; goto leave; }
    hh = atoi(s);
    if( hh < 0 || hh > 23 )
	{ rc = 1; goto leave; }
    while( isdigit(*s) )
	s++, n++;
    if( !*s || *s != ':' )
	{ rc = 1; goto leave; }
    s++, n++;
    if( !isdigit(*s) )
	{ rc = 2; goto leave; }
    mm = atoi(s);
    if( mm < 0 || mm > 59 )
	{ rc = 2; goto leave; }
    while( isdigit(*s) )
	s++, n++;
    if( *s == ':') {
	s++, n++;
	if( !isdigit(*s) )
	    { rc = 3; goto leave; }
	ss = atoi(s);
	if( ss < 0 || ss > 59 )
	    { rc = 3; goto leave; }
	while( isdigit(*s) )
	    s++, n++;
	if( *s == '.') {
	    s++, n++;
	    if( !isdigit(*s) )
		{ rc = 4; goto leave; }
	    tau = atoi(s);
	    if( tau < 0 || tau > 999 )
		{ rc = 4; goto leave; }
	    while( isdigit(*s) )
		s++, n++;
	    if( tau < 10 )
		tau *= 100;
	    else if( tau < 100 )
		tau *= 10;
	}
    }

    if( ret_tm )
	*ret_tm = (3600L*hh + 60L*mm + ss) * 1000L + tau;
  leave:
    if( ret_n )
	*ret_n = n;
    return rc;
}


/*** bottom of file ****/
