/* [timer.c wk 25.6.91] Timer Handler
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 26.08.92 wk	defines, so das nur mit ztc funktioniert
 */

#include <wk/tailor.h>
RCSID("$Id: timer.c,v 1.5 1995/03/08 16:58:42 wk Exp $")

#ifdef DOCUMENTATION
@Summary Timer...
 #include <wk/timer.h>

 int TimerOpen( int mode );
 void TimerClose( int hd );
 void TimerStart( ind hd, ulong ms );
 int  TimerQuery( int hd );
@Description
 Diese Funktionen implementieren Timer. Um eine Timer zu benutzen
 ist TimerOpen() aufzurufen. Als mode ist z.Z,. nur 0 definiert:
 Dies bedeuted, es handelt sich um einen Countdown Timer, dessen Werte in
 Millisekunden gesetzt werden. Die Funktion gibt eine Handle zurck.
 Ist dieser Handle -1, so ist kein Timer mehr verfgbar.
 Mit TimerClose() kann der Handle wieder freigegeben werden.
 TimerStart() startet eine Timer mit dem Handle hd und einer Zeit
 von ms Millisekunden.
 Mit TimerQuery() kann abgefrakt werden, ob der Timer noch luft:
 True: Timer luft noch, false Timer ist abgelaufen bzw. noch nicht
 gestarted. Abgelaufene Timer mssen immer wieder neu gestarted werden.

 Die Auflsung der Timer ist von System zu System unterschiedlich:
 Bei einem PC unter MSDOS ist die Auflsung ca. 55 ms.
#endif /*DOCUMENTATION*/



#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <wk/lib.h>
#include <wk/timer.h>
#if MSDOS || DOS16RM || DOS386
#if __ZTC__
  #include <int.h>
#endif
#else
   #error Unsupported OS
#endif

/**** constants ***/
/**** types ******/
/**** globals ****/
static int isInitialized;
static int isIntercepted;

static volatile ulong countdown0;
static volatile ulong countdown1;
static volatile ulong countdown2;

static int inUseTbl[3];

/*** local Protos ***/
static int TimerMonitor( struct INT_DATA *);
static void CleanUp( void * );
/**** Functions ****/


int TimerOpen( int type )
{
    int hd;

    if( !isInitialized ) {
	AddCleanUp( CleanUp, NULL );
      #if __ZTC__
	int_intercept(0x1c,TimerMonitor,256);
      #endif
	isIntercepted++;
	isInitialized++;
    }

  #if __ZTC__
    for( hd=0; hd < DIM( inUseTbl ); hd++ )
	if( !inUseTbl[hd] ) {
	    inUseTbl[hd]++;
	    return hd;
	}
  #endif
    return -1;
}


void TimerClose( int hd )
{
    if( hd >=0 && hd <= DIM( inUseTbl ) )
	inUseTbl[hd] = 0;
}



void TimerStart( int hd, ulong ms )
{
    ulong ticks;
  #if __ZTC__
    ticks = ms / 55;
    switch( hd ) {
      case 0:  int_off(); countdown0 = ticks; int_on(); break;
      case 1:  int_off(); countdown1 = ticks; int_on(); break;
      case 2:  int_off(); countdown2 = ticks; int_on(); break;
    }
  #endif
}



int TimerQuery( int hd)
{
    switch(hd) {
      case 0:	return countdown0 ? 1 : 0;
      case 1:	return countdown1 ? 1 : 0;
      case 2:	return countdown2 ? 1 : 0;
    }
    return 0;
}


/*
 * Interrupt drive function:
 * all counters will be counted down witrh every tick, then
 * chains to previous handlers
 */

static int TimerMonitor( struct INT_DATA *id)
{
    if( countdown0 )
	countdown0--;
    if( countdown1 )
	countdown1--;
    if( countdown2 )
	countdown2--;
    return 0;	/* Chain the existing timer tick */
}


static void CleanUp( void *dummy )
{
    if( isIntercepted ) {
	isIntercepted = 0;
       #if __ZTC__
	int_restore( 0x1c );
       #endif
    }
}

/***** bottom of File *****/
