// c_test.c
// $Id:
//
// A fully working example of how to use the NetCharge library from
// within a CGI program.
//
// To use:
// reference this c_test program via the included index.html file.
// change line 82 "test" to be your merchant instead.

// Initial CGI -POST- code based on code from Rob McCool that can
// be found at: http://hoohoo.ncsa.uiuc.edu/cgi/forms.html
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#include "netc.h"

#define MAX 50

char netcErrMsg[256];

typedef struct {
	char *var;
	char *value;
} entry;

// 5 functions from util.c (http://hoohoo.ncsa.uiuc.edu/cgi/forms.html)
char *makeword(char *line, char stop);
char *fmakeword(FILE *f, char stop, int *len);
char x2c(char *what);
void unescape_url(char *url);
void plustospace(char *str);

int main()
{
	char *temp;
	entry entries[MAX];
	transaction t;
	response resp;
	int cl, x, m=0, netcSocket;

	// We can check out our ENVIRONMENT variables for key fields..
	temp=getenv("REQUEST_METHOD");
	if (temp == NULL) {
		printf("This program needs to be called from the WWW server.\n");
		exit(1);
	}
	if (strcmp(temp, "POST") != 0) {
		printf("This CGI program requires you to POST data to it.\n");
		printf("If you don't know how to do this, please see:\n");
		printf("<A HREF=\"http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/fill-out-forms/overview.html\">forms overview</A>.%c",10);
		exit(1);
	}
	if(strcmp(getenv("CONTENT_TYPE"),"application/x-www-form-urlencoded")) {
		printf("This script can only be used to decode form results. \n");
		exit(1);
	}
	cl = atoi(getenv("CONTENT_LENGTH"));

	// Tell server what type we're sending back.
	printf("Content-type: text/html\n\n");
	printf("<PRE>");
	for(x=0;cl && (!feof(stdin));x++) {
		m=x;
		entries[x].value = fmakeword(stdin,'&',&cl);
		plustospace(entries[x].value);
		unescape_url(entries[x].value);
		entries[x].var = makeword(entries[x].value,'=');
	}

	printf("Processing Transaction\n");

	bzero(&t, sizeof(transaction));
	strcpy(t.cardnum,entries[0].value);
	strcpy(t.expiry,entries[1].value);
	strcpy(t.amount, entries[2].value);
	strcpy(t.merchant, "test");
	t.command = SALE;

	netcSocket = netcConnect(NULL); /* NULL means localhost */
	if (netcSocket == -1) {
		printf("netcConnect() failed.<HR>");
		printf("ErrMsg=%s\n",netcErrMsg);
		exit(1);
	}
	//printf("\nConnecting..\n");

	//printf("number=%s\n",entries[0].value);
	//printf("expiry=%s\n",entries[1].value);
	//printf("amount=%s\n",entries[2].value);

	//printf("Trying to do request\n");
	resp = netcTransmit(netcSocket, &t);
	if (resp.response == -1) {
		//printf("Rats, netcTransmit failed.<HR>");
		printf("response.response=%d \n",resp.response);
		printf("ErrMsg=%s\n",resp.data);
		exit(1);
	}
	//printf("\nTransaction sent successfully..\n");

//	printf("ETA for a finished transaction: %s",
//		resp.data);

	resp = netcQuery(netcSocket);
	if (resp.response == -1) {
		//printf("Rats, netcGetResult failed.\n");
		printf("response.response=%d \n",resp.response);
		printf("response.data=%s\n",resp.data);
		exit(1);
	}
	printf("\n%s\n", resp.data);


	return (0);
}

