#ifndef _NETC_H
#define _NETC_H
/* See http://www.bugless.com/docs.html for the latest documentation */
/* on netc.h                                                         */
/* netc.h */
/* $Id:   */

/* Copyright 1996 Bugless Commerce Software Inc. -BCSI- (support@bugless.com)
 * All rights reserved.
 * 
 * This file is part of a credit card processing solution written by
 * Bugless Commerce Software Inc. (support@bugless.com).
 * This library is FREE FOR COMMERCIAL AND NON-COMMERCIAL USE
 * as long as the following conditions are aheared to.
 * 
 * Copyright remains BCSI's, and as such any Copyright notices
 * are not to be removed.  If this code is used in a product,
 * BCSI should be given attribution as the author of the parts used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package or
 * in HTML on the same WWW page NetCharge is used.
 * 
 * Redistribution and use in source and binary forms
 * are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Bugless Commerce Software
 *    (support@bugless.com)
 * 
 * THIS SOFTWARE IS PROVIDED BY BUGLESS COMMERCE SOFTWARE ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */


/*  sizes for the elements in transaction. */
#define MERCHANTSIZE	32
#define CARDSIZE		32
#define EXPIRYSIZE		5
#define AMOUNTSIZE		12
#define AUTHSIZE		16
#define OPERATORSIZE	4
#define TERMINALSIZE	21	// Changed to MDI
#define REFERENCESIZE	8
#define ST_ADDRESSSIZE	128
#define ZIPSIZE			16
#define POSITIONSIZE	16

/* commands */
#define SALE			0x01
#define REFUND			0x02
#define VOID			0x03
#define PREAUTH			0x04
#define SETTLE			0x05
#define AVSZIP			0x06
#define AVSSTREET		0x07
#define AVSZIPSTREET	0x08
#define HOSTTOTALS		0x09
#define AUTHONLY		0x0A

/* protocols */
#define NETCTEXT		2
#define NETCSCRAMBLE	4
#define NETCSSL			8
#define NETCABORT		16

#define ETA_RESULT		-2

extern char netcErrMsg[256];

/* The software using this library will fill out this structure and */
/* call netcTransmit(). */
#ifdef __cplusplus
typedef struct transaction {
#else
typedef struct transact {
#endif
	char merchant[MERCHANTSIZE];    /* which merchant are we processing? */
	char command;                   /* SALE, REFUND, etc.. */
	char protocol;					/* NETCTEXT, NETCSCRAMBLE, NETCSSL */
	char cardnum[CARDSIZE];
	char expiry[EXPIRYSIZE];        /* forced MMYY */
	char amount[AMOUNTSIZE];        /* 999.50, 0.50, .50, .05 */
                                    /* Note, Library removes '.' internally */
	char auth[AUTHSIZE];            /* The saved authorization number */
	char operator_id[OPERATORSIZE]; /* For multiple terminals/merchant */
	char terminal_id[TERMINALSIZE]; /* Merchant # or Terminal # Internal use */
	int product_code;               /*Associates product code with transaction*/
	char ctype;                     /* Credit card type. Internal use only */
	char referencenum[REFERENCESIZE]; /* For TDSI */
	char st_address[ST_ADDRESSSIZE];/* address verification */
	char zip[ZIPSIZE];              /* address verification */
	char avsop[7];						/* How to handle AVS return codes */
	char position[POSITIONSIZE];	/* Position in the success log */
	char host_total_level;          /* For MDI HOST TOTALS (settlement) */
	char from_date[7];              /* MMDDYY for HOST TOTALS */
#ifdef __cplusplus
bool transaction::operator == (struct transaction x)
{
	if (memcmp(this, &x, sizeof(transaction)) == 0)
		return (true);
	return (false);
}

bool transaction::operator < (struct transaction x)
{
	if (memcmp(this, &x, sizeof(transaction)) == 0)
		return (true);
	return (false);
}
#endif
#ifdef __cplusplus
};
#else
}transaction;
#endif

/* netcTransmit() returns this structure */
#ifdef __cplusplus
typedef struct response {
#else
typedef struct responss {
#endif
	char response;	// 0,1,2 = Succeded, Failed, ETA response
	char data[128];
#ifdef __cplusplus
};
#else
} response;
#endif

#ifdef __cplusplus
extern "C" int netcConnect(char *);
extern "C" response netcTransmit(int, transaction*);
extern "C" response netcQuery(int);
#else
int netcConnect(char *);
response netcTransmit(int, transaction*);
response netcQuery(int);
#endif

#endif /* _NETC_H */

