/* refund.c
 *
 * program to process REFUND transactions
 *
 */

#include <stdio.h>
#include <string.h>
#include "netc.h"

void usage()
{
	printf("\nUsage: refund <merchant> <card number> <expiry> <amount>\n");
	printf("Example: refund bcsi 1234567891234 1299 15.99\n");
}

int main(int argc, char **argv)
{
	transaction trans;
	response resp;
	int netcSocket;

	if (argc != 5) {
		usage();
		exit(-1);
	}
	bzero(&trans, sizeof(transaction));
	strcpy(trans.merchant, argv[1]);
	trans.command = REFUND;
	strcpy(trans.cardnum, argv[2]);
	strcpy(trans.expiry, argv[3]);
	strcpy(trans.amount, argv[4]);
	netcSocket = netcConnect(NULL); // NULL means localhost
	if (netcSocket == -1) {
		printf("netcConnect() failed.\n");
		printf("netcErrMsg=%s\n",netcErrMsg);
		exit(1);
	}
	printf("\nConnecting..\n");

	// netcTransmit() returns the rough transaction ETA
	resp = netcTransmit(netcSocket, &trans);
	if (resp.response == -1) {
		printf("Rats, netcTransmit failed.\n");
		printf("response.response=%d \n",resp.response);
		printf("response.data=%s\n",resp.data);
		exit(1);
	}
	printf("ETA for a finished transaction: %s\n", resp.data);

	resp = netcQuery(netcSocket);
	if (resp.response == -1) {
		printf("Rats, netcGetResult failed.\n");
		printf("response.response=%d \n",resp.response);
		printf("response.data=%s\n",resp.data);
		exit(1);
	}
	printf("\nResult code:%c(%d), message:%s\n", resp.response,
		resp.response, resp.data);

	return (0);
}

