// viewtotals.cc
// Displays in human readable format the protocol.totals file.
//

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>

#include "netc.h"
#include "totals.h"

// Usage: viewtotals <file>
main(int argc, char **argv)
{
	int fd;
	char filename[128];
	totals t;

	if (argc != 2) {
		printf("viewtotals <file>\n");
		exit(-1);
	}
		
	if ( (fd=open(argv[1], O_RDONLY)) == -1) {
		printf("open %s failed:%s",filename,sys_errlist[errno]);
		exit(-1);
	}
	
	if (read(fd, &t, sizeof(totals)) <(int)sizeof(totals)) {
		printf("read failed:%s",sys_errlist[errno]);
		exit(-1);
	}

	//for (i=0; i<(int)sizeof(totals)/4; ++i) {
	//	printf("%d,",*(&t+i));
	//}
	printf("\ntransaction_number = %d\n",t.transaction_number);
	printf("batch_number = %d\n",t.batch_number);
	printf("return_count = %d\n",t.return_count);
	printf("return_total = %d\n",t.return_total);
	printf("sale_count = %d\n",t.sale_count);
	printf("sale_total = %d\n",t.sale_total);
	printf("mastercard total = %d\n",t.card_total[1]);
	printf("Visa total = %d\n",t.card_total[2]);
	printf("amex total = %d\n",t.card_total[3]);
	printf("diners total = %d\n",t.card_total[4]);
	printf("discover total = %d\n",t.card_total[5]);
	printf("enroute total = %d\n",t.card_total[6]);
	printf("jcb total = %d\n",t.card_total[7]);
	printf("bankcard total = %d\n",t.card_total[8]);

}

