/* void.c
 *
 * program to process VOID transactions
 *
 * cat the merchant.protocol.success log to find the position of the
 * transaction you wish to void. Keep in mind the first position starts at
 * zero.
 *
 */

#include <stdio.h>
#include <string.h>
#include "netc.h"

void usage()
{
	printf("\nUsage: sale <merchant> <position>\n");
	printf("Example: void bcsi 0 (This voids the first transaction)\n");
}

int main(int argc, char **argv)
{
	transaction trans;
	response resp;
	int netcSocket;

	if (argc != 3) {
		usage();
		exit(-1);
	}
	bzero(&trans, sizeof(transaction));
	strcpy(trans.merchant, argv[1]);
	strcpy(trans.position, argv[2]);
	trans.command = VOID;
	netcSocket = netcConnect(NULL); // NULL means localhost
	if (netcSocket == -1) {
		printf("netcConnect() failed.\n");
		printf("netcErrMsg=%s\n",netcErrMsg);
		exit(1);
	}
	printf("\nConnecting..\n");

	// netcTransmit() returns the rough transaction ETA
	resp = netcTransmit(netcSocket, &trans);
	if (resp.response == -1) {
		printf("Rats, netcTransmit failed.\n");
		printf("response.response=%d \n",resp.response);
		printf("response.data=%s\n",resp.data);
		exit(1);
	}
	printf("ETA for a finished transaction: %s\n", resp.data);

	resp = netcQuery(netcSocket);
	if (resp.response == -1) {
		printf("Rats, netcGetResult failed.\n");
		printf("response.response=%d \n",resp.response);
		printf("response.data=%s\n",resp.data);
		exit(1);
	}
	printf("\nResult code:%c(%d), message:%s\n", resp.response,
		resp.response, resp.data);

	return (0);
}

