/*
pbm2ppm.c Version 0.2.0 - Convert PBM to PPM
Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* Example of a PBM header */
/* 000000  50342031 37323820  32313536 0a000000  {P4 1728 2156    }  */
/* 000010  00000000 00000000  00000000 00000000  {                }  */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#define PBMBIT(bit) \
	 { \
	 if (*p & bit) \
            { \
	    *r++ = (unsigned char) 0; \
            *r++ = (unsigned char) 0; \
            *r++ = (unsigned char) 0; \
	    } /* if foreground */ \
	 else \
            { \
	    r += 3; \
	    } /* else background */ \
         rowsz++; \
	 if (rowsz >= wdth) break; \
	 }

int getbyte()
   {
   int rdlen;
   unsigned char buf[8];
   rdlen = read(0,buf,1);
   if (rdlen == 1) return(buf[0]);
   if (!rdlen) return(EOF);
   fprintf(stderr,"pbm2ppm: stdin rdlen %d\n",
      rdlen);
   perror("Read error");
   exit(1);
   } /* getbyte */

int getblk(len,blk)
int len;
unsigned char *blk;
   {
   int totlen;
   int rdlen;
   totlen = len;
   while (totlen > 0)
      {
      rdlen = read(0,blk,totlen);
      totlen -= rdlen;
      if (!rdlen) return(len - totlen);
      else if (rdlen < 0)
	 {
         perror("pbm2ppm: stdin read error");
         exit(1);
	 } /* read error */
      } /* read loop */
   return(len);
   } /* getblk */

void putbyte(ch)
int ch;
   {
   int wrtlen;
   unsigned char buf[8];
   buf[0] = (unsigned char) ch;
   wrtlen = write(1,buf,1);
   if (wrtlen != 1)
      {
      fprintf(stderr,"pbm2ppm: wrtlen %d\n",
         wrtlen);
      perror("Write error");
      exit(1);
      } /* write err */
   } /* putbyte */

void putblk(len,blk)
int len;
unsigned char *blk;
   {
   int totlen;
   int wrtlen;
   totlen = len;
   while (totlen > 0)
      {
      wrtlen = write(1,blk,len);
      totlen -= wrtlen;
      if (!totlen) return;
      else if (totlen < 0)
	 {
         fprintf(stderr,"pbm2ppm: wrtlen %d\n",
            len - totlen);
         fprintf(stderr,"Len should be %d\n",
            len);
         perror("Write error");
         exit(1);
	 } /* if write error */
      else if (wrtlen < 0)
	 {
         perror("pbm2ppm: write error");
         exit(1);
	 } /* if write error */
      } /* write loop */
   } /* putblk */

void hdrerr(msg)
char *msg;
   {
   fprintf(stderr,"pbm2ppm: header error\n");
   fprintf(stderr,"%s\n", msg);
   exit(1);
   } /* hdrerr */

int main()
   {
   int wdth;
   int hght;
   int rowsz;
   int rownum;
   int octets;
   int ch;
   int blklen;
   int ppmrowsz;
   int len;
   unsigned char *p,*q,*r;
   char str[128];
   unsigned char *ipt;
   unsigned char *opt;
   if ((ch = getbyte()) != 'P')
      hdrerr("Byte 1 is not 'P'");
   else putbyte(ch);
   /* convert P4 to P6 */
   if ((ch = getbyte()) != '4')
      hdrerr("Byte 2 is not '4'");
   else putbyte('6');
   while ((ch = getbyte()) == ' ' ||
      ch == '\r' || ch == '\t'
      || ch == '\n' || ch == '#')
      {
      if (ch == '#')
	 {
	 putbyte(ch);
         while ((ch = getbyte()) != '\n'
	    && ch != EOF)
	    putbyte(ch);
	 if (ch == EOF)
	    hdrerr("End of file reading header.");
	 else putbyte(ch);
	 continue;
	 } /* comment */
      else putbyte(ch);
      } /* white space */
   if (ch < '0' || ch > '9') hdrerr("Width error");
   wdth = hght = 0;
   while (ch >= '0' && ch <= '9')
      {
      wdth = (wdth * 10) + (ch - '0');
      putbyte(ch);
      ch = getbyte();
      } /* for each digit */
   if (ch == ' ' || ch == '\t' ||
      ch == '\r' || ch == '\n')
      putbyte(ch);
   else hdrerr("Width error");
   while ((ch = getbyte()) == ' ' ||
      ch == '\r' || ch == '\t'
      || ch == '\n' || ch == '#')
      {
      if (ch == '#')
	 {
         putbyte(ch);
         while ((ch = getbyte()) != '\n'
	    && ch != EOF)
            putbyte(ch);
         if (ch == EOF)
            hdrerr("End of file reading header.");
	 else putbyte(ch);
	 continue;
	 } /* comment */
      else putbyte(ch);
      } /* white space */
   if (ch < '0' || ch > '9') hdrerr("Height error");
   while (ch >= '0' && ch <= '9')
      {
      hght = (hght * 10) + (ch - '0');
      putbyte(ch);
      ch = getbyte();
      } /* for each digit */
   if (ch == '\n' || ch == ' ' ||
      ch == '\t' || ch == '\r')
      putbyte(ch);
   else hdrerr("Height error");
   strcpy(str,"255\n");
   // sprintf(str,"P6 %d %d 255\n",
      // wdth, hght);
   len = strlen(str);
   p = (unsigned char *) str;
   q = (unsigned char *) p + len;
   while (p < q) putbyte(*p++);

   /* number of bytes in PBM row */
   octets = (wdth + 7) >> 3;

   ipt = (unsigned char *) malloc(octets + 16);
   if (ipt == NULL)
      {
      fprintf(stderr,"pbm2ppm: out of memory "
	 "allocating ipt\n");
      exit(1);
      } /* out of mem */

   ppmrowsz = wdth * 3;
   opt = (unsigned char *) malloc(ppmrowsz + 16);
   if (opt == NULL)
      {
      fprintf(stderr,"pbm2ppm: out of memory "
	 "allocating opt\n");
      exit(1);
      } /* out of mem */

   rownum = 0;
   blklen = 999999;
   while (blklen)
      {
      blklen = getblk(octets,ipt);
      if (!blklen)
	 {
	 if (rownum != hght)
	    {
	    fprintf(stderr,"pbm2ppm: rows read = %d\n",
	       rownum);
	    fprintf(stderr,"Should have read %d rows.\n",
	       hght);
	    exit(1);
	    } /* invalid # rows */
	 else break;
	 } /* if eof */
      rownum++;
      if (blklen != octets)
	 {
	 fprintf(stderr,"pbm2ppm: row %d "
	    "has %d bytes\n",
	    rownum, blklen);
	 fprintf(stderr,"Should read %d "
	    "bytes in each row.\n",
	    octets);
	 exit(1);
	 } /* short block */
      /* fill the white background */
      p = (unsigned char *) opt;
      q = (unsigned char *) p + ppmrowsz;
      while (p < q) *p++ = (unsigned char) 255;
      rowsz = 0;
      p = (unsigned char *) ipt;
      q = (unsigned char *) p + octets;
      r = (unsigned char *) opt;
      while (p < q)
	 {
	 PBMBIT(0x80)
	 PBMBIT(0x40)
	 PBMBIT(0x20)
	 PBMBIT(0x10)
	 PBMBIT(0x08)
	 PBMBIT(0x04)
	 PBMBIT(0x02)
	 PBMBIT(0x01)
	 p++;
	 } /* for each octet in row */
      if (rowsz != wdth)
	 {
	 fprintf(stderr,"pbm2ppm: row length "
	    "was %d x 3 = %d bytes\n",
	    rowsz, rowsz * 3);
	 fprintf(stderr,"Should be %d x 3 = %d bytes.\n",
	    wdth, wdth * 3);
	 exit(1);
	 } /* wrong length row */
      putblk(ppmrowsz,opt);
      } /* for each block */
   free(ipt);
   free(opt);
   return(0);
   } /* main */
