#include "event.h"

#define abs(x) ((x)<0?(-(x)):(x))

inline void
points (int x1, int y1, unsigned long c, etyp event)
{
  switch (event.depth)
    {
    case 24:
    case 32:
      {
	unsigned long *dat = (unsigned long *) event.data[event.nr_i];
	dat[(event.bytes_line /*>> 2 */ ) * y1 + x1] = c & event.byte;
      }
      break;

    case 16:
      {
	short int *dat = (short int *) event.data[event.nr_i];
	dat[(event.bytes_line /*>> 2 */ ) * y1 + x1] = c & event.byte;
      }
      break;

    }

}

inline void
line (int x1, int y1, int x2, int y2, unsigned long c, etyp event)
{
  if (x1 == x2 && y1 == y2)
    {
      points (x1, y1, c, event);
    }
  else
    {
      if (x1 == x2)
	{
	  int ya = (y1 < y2 ? y1 : y2), yb = (y1 > y2 ? y1 : y2);
	  for (; ya <= yb; ya++)
	    points (x1, ya, c, event);
	}
      else if (y1 == y2)
	{
	  int xa = (x1 < x2 ? x1 : x2), xb = (x1 > x2 ? x1 : x2);
	  for (; xa <= xb; xa++)
	    points (xa, y1, c, event);
	}
      else
	{
	   if(abs(y2-y1)/abs(x2-x1)<=1){
             float m = (float)(y2-y1)/(float)(x2-x1);
             int xa = (x1 < x2 ? x1 : x2), xb = (x1 > x2 ? x1 : x2);
	     int ya = (x1 < x2 ? y1 : y2);
             float x;
             for (x=0; x+xa <= xb; x++)
	        points ((int)x+xa, (int)x*m+ya, c, event);

           } else {
             float m = (float)(x2-x1)/(float)(y2-y1);
             int ya = (y1 < y2 ? y1 : y2), yb = (y1 > y2 ? y1 :y2);
             int xa = (y1 < y2 ? x1 : x2);
             float y;
	     for (y=0; y+ya <= yb; y++)
	        points ((int)y*m+xa, (int)y+ya, c, event);
           }


	}

    }
}


inline void
arena (int x1, int y1, int x2, int y2, unsigned long c, etyp event)
{
  switch (event.depth)
    {
    case 24:
    case 32:
      {
	unsigned long *dat = (unsigned long *) event.data[event.nr_i];
	//char *dat=(char *)event.data[event.nr_i] ;
	if (x1 == x2 && y1 == y2)
	  {
	    dat[(event.bytes_line) * y1 + x1] = c & event.byte;
	  }
	else
	  {
	    int x = x1, y = y1 - 1;
	    for (; (y = (x == x1 ? y + 1 : y)) <= y2; x = (x < x2 ? x + 1 : x1))
	      dat[(event.bytes_line) * y + x] = c & event.byte;
	  }
      }
      break;

    case 16:
      {
	short int *dat = (short int *) event.data[event.nr_i];
	if (x1 == x2 && y1 == y2)
	  {
	    dat[(event.bytes_line) * y1 + x1] = c & event.byte;
	  }
	else
	  {
	    int x = x1, y = y1 - 1;
	    for (; (y = (x == x1 ? y + 1 : y)) <= y2; x = (x < x2 ? x + 1 : x1))
	      dat[(event.bytes_line) * y + x] = c & event.byte;
	  }

      }
      break;

    }
}
	  
/*	     inline void
	     filter (int x1, int y1, int x2, int y2, unsigned long filter, etyp event)
	     {

	     //unsigned long *dat = (unsigned long *)event.data[event.nr_i];
	     char *dat = (char *) event.data[event.nr_i];
	     if (x1 == x2 && y1 == y2)
	     {
	     dat[(event.bytes_line) * y1 + x1] &= filter;
	     }
	     else
	     {
	     int x = x1, y = y1 - 1;
	     x2 = (x2 < event.width ? x2 : event.width - 1);
	     y2 = (y2 < event.height ? y2 : event.height - 1);
	     for (; (y = (x == x1 ? y + 1 : y)) <= y2; x = (x < x2 ? x + 1 : x1))
	     dat[(event.bytes_line) * y + x] &= filter;
	     }
	     }
*/

/*	   
inline void
copyim (int x1, int x2, int y1, int y2, int xp, int yp, etyp event)
{
   if (x1 == x2 && y1 == y2)
     {
     event.data[event.nr_i][(event.bytes_line >> 2) * yp + xp] = event.data[(event.bytes_line >> 2) * y1 + x1];
     }
     else if(!(x1 == xp && y1 == xp))
     {
     int x = x1, y = y1 ;
     x2 = (x2 < event.width ? x2 : event.width - 1);
     y2 = (y2 < event.height ? y2 : event.height - 1);
     for (; (y = (x == x1 ? y + 1 : y)) <= y2; x = (x < x2 ? x + 1 : x1))
     event.data[event.nr_i][(event.bytes_line >> 2) * y + x] &= filter;
     }          
}
*/

