/*
 * 
 * Markus Fraczek (marekf@gmx.net)
 * 
 * Xrsf  
 */


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include "event.h"
#include "win.h"
#include "gi.h"
#include "timer.h"
#include "imtext.h"
#include "image.h"


#include "info.h"
#include "color.h"
#include "render.h"

#define abs(x) ((x) < 0 ?(-(x)):(x))


static mcolor c[MAXCOLOR];
static int nr_max = 0;
static etyp event;
static rtyp rinfo;




void
init_info(){
  rinfo.mx = 0;
  rinfo.my = 0;
  rinfo.zo= 40+MAXZO;
  rinfo.zt= MAXZO;
  rinfo.iter= MAXITER;
  rinfo.iterz= MAXITER;
  rinfo.big=0.01;
}

int
main (int argc, char **argv)
{
  int i = 0;
  int done = 0,to_swap=0;
  int dt;
  int full=1;
  double fi;
  struct timeval etime, now, stime;
  
  event.full=FULL; 
  
  for(i=1;i<argc;i++){
    if(strcmp(argv[i],"-f") == 0 || strcmp(argv[i],"--full") ==0)
      event.full=1;
    else if(strcmp(argv[i],"-h") ==0 || strcmp(argv[i],"--help")==0){
      printf ("usage: xref [-f] [-h]\n");
      printf ("-f, --full \tfullscreen mode\n");
      printf ("-h, --help \tshow this usage message\n");
      printf ("\nQUIT:     ESC\n");
      printf ("ZOOM IN:  mouse button 1\n");
      printf ("ZOOM OUT: mouse button 2\n");
      printf ("MOVE:     mouse button 3\n");
      exit (0);
    }
  }
  

  init_gi (&event);

  if(event.depth != 16 && event.depth != 24 && event.depth != 32){
     printf("fail:  %d\n",event.depth);
     exit (0);
  }
  
  


  event.byte=0;
  for(i=0;i<event.depth;++i)
     event.byte|=1<<i;
  



  for (i=0; i < MAXCOLOR; i++)
    {
      fi=(double)i/(double)MAXCOLOR;
      switch (event.depth)
        {
        case 24:
        case 32:
          c[i].pixel = 0xffffff *fi;
          break;
        case 16:
          c[i].pixel = 0xffff*fi;
          break;
        case 8:

          break;
        }

     c[i].nr = i;
        
    }

  nr_max =0;//= i;

//  swap_buffer (&event);
//  get_event (&event);

  gettimeofday (&stime, NULL);
//  gettimeofday (&etime, NULL);

  init_info();
  swap_buffer (&event);
  get_event (&event);
  gettimeofday (&etime, NULL);
  while (!(QUIT & event.events))
    {
      get_event (&event);
      if (event.events & RESIZE || event.events & UPDATE)
	{
        //   rinfo.zo = MAXZO;
	//  rinfo.zt= MAXZO;
  
          rinfo.iter = (rinfo.iter > rinfo.iterz ? rinfo.iterz : rinfo.iter);
          rinfo.zo= (rinfo.zo < rinfo.zt ? rinfo.zt : rinfo.zo);
	  full=1;
	  done = 0;
	}
      
      if (event.Buttons & B1)
	{
	  rinfo.big /= 1.1;
	  rinfo.big = rinfo.big < 0.0 ? 0.0 : rinfo.big;
	  done = 0;
	  rinfo.iter = (rinfo.iter > rinfo.iterz ? rinfo.iterz : rinfo.iter);
	  rinfo.zo= (rinfo.zo < rinfo.zt ? rinfo.zt : rinfo.zo);
	  //  event.Buttons &= ~B1;
	  //  gettimeofday (&etime, NULL);
	}
      if (event.Buttons & B2)
	{
	  rinfo.big *= 1.1;
	  done = 0;
	  rinfo.iter = (rinfo.iter > rinfo.iterz ? rinfo.iterz : rinfo.iter);
	  rinfo.zo = (rinfo.zo < rinfo.zt ? rinfo.zt : rinfo.zo);
	  //  event.Buttons &= ~B3;
	  //  gettimeofday (&etime, NULL);
	}
      if (event.Buttons & B3)
	{
	  rinfo.mx += 0.05 * (((long double) event.mx - (long double) event.width * 0.5) * rinfo.big);
	  rinfo.my += 0.05 * (((long double) event.my - (long double) event.height * 0.5) * rinfo.big);
	  //  event.Buttons &= ~B2;

	  done = 0;
          rinfo.zo = (rinfo.zo < rinfo.zt ? rinfo.zt : rinfo.zo);
	
	
	}
	 
     gettimeofday (&stime, NULL);

     if (!done && !(event.events & RESIZE || event.events & UPDATE))
	{
          rinfo.x1=0;
          rinfo.x2=event.width-1;
          rinfo.y1=0;
          rinfo.y2=event.height-1;
          render (&rinfo,&event,c,full);
          done=1;
          to_swap=1;
	  full = (full == 1 ? 0:full);
        }

      if(to_swap){
        swap_buffer (&event);
        to_swap=0;
      }
      gettimeofday (&now, NULL);
      if (event.Buttons & (B1 | B2 | B3))
	{
	  dt=DTIME (stime, now);
	  if (dt < 30000)
	    {
	      if (rinfo.zo > 1 )
		rinfo.zo--;

	      //        if (iter<MAXITER)
	      //           iter++;
	    }
	  if (dt < 50000)
	    {
	      rinfo.zt = rinfo.zo;
	      rinfo.iterz = rinfo.iter;
	    }
	  else
	    {
	      if (rinfo.zo < MAXZO )
		rinfo.zo++;
              //         else
	      //           rinfo.iter-=(rinfo.iter>10?1:0);
	    }

	}
	dt =DTIME (stime, now);
      if (dt < 40000 && done && !(event.Buttons & (B1 | B2 | B3)))
	{
	  if (rinfo.zo == 0   && !(dt < 40000 && rinfo.iter < MAXITER))
	    usleep (40000 - dt);
	  else
	    {
	      if (rinfo.zo == 0 )
		rinfo.iter = (rinfo.iter < MAXITER ? rinfo.iter + 100 : rinfo.iter);
	      else
                rinfo.zo = (rinfo.zo > 2 ? rinfo.zo - 2 : 0);
              done = 0;
	    }
	}
//      gettimeofday (&stime, NULL);

    }
//  gettimeofday (&now, NULL);
//  printf ("TIME %d\n", DTIME (etime, now));
//  printf ("%lx\n", event.data[0][0]);
//  printf ("%d\n", event.bytes_line);
  close_gi ();
  printf("Xref-0.1.1\n");
  return 0;
}

