#include <stdlib.h>
#include <stdio.h>
#include "event.h"
#include "win.h"
#include "Xint.h"
#include "color.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysymdef.h>
#include <X11/keysym.h>
#ifdef IMAGESHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif



char *dpyname = NULL;
static Display *dpy;
static int screen;
static XSetWindowAttributes attributes;
static unsigned long attr_mask;
static unsigned int class;
static Window parent_window;
static Visual *defaultvisual;
static int depth;
static Colormap defaultcolormap;
static Colormap colormap;
static Window window;
static XClassHint classHint;
static XWMHints *hints;
static Atom wmDeleteWindow;
static GC gc;
static XGCValues xgcvalues;
#if defined (IMAGE)
static XImage *image;
static Drawable Buffer;
#elif defined IMAGESHM
static XImage *image[NR_IMAGE];
static XShmSegmentInfo shminfo[NR_IMAGE];
static Drawable Buffer;
static int Completion;
static int ready;
static unsigned int blackpixel;
static int nr_i;
#else
static Drawable Buffer;
#endif

static unsigned int height, width;
static XEvent ev;
static XColor color[MAXCOLOR];
static int color_nr = 0;


unsigned long
x11_color (int r, int g, int b, int nr)
{
  color[nr].flags = DoRed | DoGreen | DoBlue;
  color[nr].red = r;
  color[nr].green = g;
  color[nr].blue = b;
  XAllocColor (dpy, colormap, &color[nr]);
  ++color_nr;
  return (color[nr].pixel);
}


int
x11_back (int nr)
{
  XSetBackground (dpy, gc, color[nr].pixel);
  return 1;
}

int
x11_fore (int nr)
{
  XSetForeground (dpy, gc, color[nr].pixel);
  return 1;
}


#ifdef IMAGESHM
/*int
cleanImage (int nr)
{
  {
    register unsigned long *dp = (unsigned long *) image[nr]->data;
    register int i = (image[nr]->bytes_per_line >> 2) * image[nr]->height;
    while (--i >= 0)
      *dp++ = blackpixel;

  }
  return 1;
}*/
#endif

int
x11_swap (etyp * event)
{

#if defined IMAGE
  XPutImage (dpy, Buffer, gc, image, 0, 0, 0, 0, width, height);

#elif defined IMAGESHM
//  if (event->ready == 1)
  {
    XShmPutImage (dpy, Buffer, gc, image[event->nr_i], 0, 0, 0, 0, image[event->nr_i]->width, image[event->nr_i]->height, True);
    // event->ready = 0;
    //  nr_i=(nr_i<(NR_IMAGE-1)?nr_i+1:0);
    // cleanImage (nr_i);
    //   event->data[event->nr_i] =(unsigned long *) image[event->nr_i]->data;
  }
  XSync (dpy, False);
//#endif
  nr_i = event->nr_i;
#else
  XFlush (dpy);
#endif
  return 1;
}



int
x11_drawline (int x_s, int y_s, int x_e, int y_e, int nr)
{
#if defined IMAGE
  XPutPixel (image, x_s, y_s, color[nr].pixel);
#elif defined IMAGESHM
  int dx, dy;
  dx = (x_s < x_e ? 1 : x_s > x_e ? -1 : 0);
  dy = (y_s < y_e ? 1 : y_s > y_e ? -1 : 0);
  do
    {
      XPutPixel (image[nr_i], x_s, y_s, color[nr].pixel);
      if (x_s == x_e)
	y_s += dy;
      else if (y_s == y_e)
	x_s += dx;
      else if ((float) (abs (y_s - y_e)) / (float) (abs (x_s - x_e)) <= 0.5)
	x_s += dx;
      else if ((float) (abs (y_s - y_e)) / (float) (abs (x_s - x_e)) >= 2.0)
	y_s += dy;
      else
	y_s += dy, x_s += dx;

    }
  while (!(x_s == x_e && y_s == y_e));

#else
  XDrawLine (dpy, Buffer, gc, x_s, y_s, x_e, y_e);
#endif
  return 1;
}

int
x11_drawpoint (int x, int y, int nr)
{
#if defined IMAGE
  XPutPixel (image, x, y, color[nr].pixel);
#elif defined IMAGESHM
  XPutPixel (image[nr_i], x, y, color[nr].pixel);
#else
  XDrawPoint (dpy, Buffer, gc, x, y);
#endif
  return 1;
}




int
x11_event (etyp * event)
{
#if defined IMAGESHM
  int i;
#endif
  event->events = 0;
  if (XPending (dpy))
    {
      do
	{
	  XNextEvent (dpy, &ev);
	  switch (ev.type)
	    {

	    case ClientMessage:
	      if (ev.xclient.format == 32 && ev.xclient.data.l[0] == wmDeleteWindow)
		event->events = QUIT;
	      break;
	    case MotionNotify:
	      event->mx = ev.xmotion.x;
	      event->my = ev.xmotion.y;
	      event->Buttons = (ev.xmotion.state >> 8) & (B1 | B2 | B3);
	      break;
	    case ButtonRelease:
	      event->mx = ev.xbutton.x;
	      event->my = ev.xbutton.y;
	      switch (ev.xbutton.button)
		{
		case 1:
		  event->Buttons &= ~B1;
		  break;
		case 2:
		  event->Buttons &= ~B2;
		  break;
		case 3:
		  event->Buttons &= ~B3;
		  break;
		}
	      break;

	    case ButtonPress:
	      event->mx = ev.xbutton.x;
	      event->my = ev.xbutton.y;
	      if (event->mx < 0 || event->my < 0 || event->mx > event->width || event->my > event->height)
		break;
	      switch (ev.xbutton.button)
		{
		case 1:
		  event->Buttons |= B1;
		  break;
		case 2:
		  event->Buttons |= B2;
		  break;
		case 3:
		  event->Buttons |= B3;
		  break;
		}
	      break;
	    case KeyRelease:
	      {
		KeySym ksym;
		switch (ksym = XLookupKeysym (&ev.xkey, 0))
		  {
		  case XK_Escape:
		    event->key &= ~ESC;
		    break;
		  case XK_Up:
		    event->arrow &= ~UP;
		    break;
		  case XK_Down:
		    event->arrow &= ~DOWN;
		    break;
		  }
	      }
	      break;

	    case KeyPress:
	      {
		KeySym ksym;
		switch (ksym = XLookupKeysym (&ev.xkey, 0))
		  {
		  case XK_Escape:
		    event->key |= ESC;
		    event->events = QUIT;
		    break;
		  case XK_Up:
		    event->arrow |= UP;
		    break;
		  case XK_Down:
		    event->arrow |= DOWN;
		    break;
//                   case XK_F1:
//		     event->events = QUIT;
//		    break;
		  default:
		    break;

		  }
	      }
	      break;

	    case ConfigureNotify:
	      {
		int tmp;
		Window wtmp;
		int w1, h1;
		w1 = event->width;
		h1 = event->height;
		XSync (dpy, 0);
		XGetGeometry (dpy, window, &wtmp, &tmp, &tmp, &(event->width), &(event->height), (unsigned int *) &tmp, (unsigned int *) &tmp);
		if (event->width != w1 || event->height != h1)
		  event->events |= RESIZE;
#ifdef IMAGE
		if (event->width != w1 || event->height != h1)
		  {
		    XDestroyImage (image);
		    image = XCreateImage (dpy, defaultvisual, depth, ZPixmap, 0, NULL, event->width, event->height, 8, 0);
		    image->data = malloc (image->bytes_per_line * event->height);
		  }
#elif defined IMAGESHM
		if (event->width != w1 || event->height != h1)
		  {
		    /*   while( event->ready != 1){
		       XNextEvent (dpy, &ev);
		       if (ev.xany.type == Completion)
		       event->ready =1;
		       }  */
		    for (i = 0; i < NR_IMAGE; ++i)
		      {
			XDestroyImage (image[i]);
			XShmDetach (dpy, &shminfo[i]);
			shmdt (shminfo[i].shmaddr);
			shmctl (shminfo[i].shmid, IPC_RMID, 0);
		      }
		    for (i = 0; i < NR_IMAGE; ++i)
		      {
			image[i] = XShmCreateImage (dpy, defaultvisual, depth, ZPixmap, NULL, &shminfo[i], event->width, event->height);
			//image->data = malloc (image->bytes_per_line * y);
			shminfo[i].shmid = shmget (IPC_PRIVATE,
						   image[i]->bytes_per_line * image[i]->height, IPC_CREAT | 0777);
			shminfo[i].shmaddr = image[i]->data = shmat (shminfo[i].shmid, 0, 0);
			shminfo[i].readOnly = False;
			XShmAttach (dpy, &shminfo[i]);
		      }
		    //    event->data =(unsigned long *) image[nr_i]->data;
		    switch (depth)
		      {
		      case 24:
		      case 32:
			event->bytes_line = image[0]->bytes_per_line >> 2;
			break;
		      case 16:
		      case 8:
			event->bytes_line = image[0]->bytes_per_line >> 1;
			break;
		      }
		    //  event->bytes_line = image[0]->bytes_per_line;
		  }
#endif
		height = event->height, width = event->width;
	      }
	      break;


	    case Expose:
	      event->events = UPDATE;
	      break;
	    default:
#ifdef IMAGESHM
	      if (ev.xany.type == Completion)
		{
		  //    cleanImage(nr_i);
		  //  nr_i ^= 1;
		  event->ready = 1;
		}
#endif
	      break;
	    }
	}
      while (XEventsQueued (dpy, QueuedAlready));
    }
  return 0;
}

int
x11_init (etyp * event)
{
  unsigned int x, y, border;
  char buff[255];
  int i;
  dpyname = &buff[0];

  dpyname = getenv ("DISPLAY");

  dpy = XOpenDisplay (dpyname);
  screen = DefaultScreen (dpy);
  attributes.background_pixel = BlackPixel (dpy, screen);
  attributes.border_pixel = BlackPixel (dpy, screen);
  attributes.event_mask = ButtonPressMask | StructureNotifyMask |
    ButtonReleaseMask | ButtonMotionMask | KeyPressMask |
    ExposureMask | KeyReleaseMask;

  attr_mask = CWBackPixel | CWEventMask;
  class = InputOutput;
  parent_window = RootWindow (dpy, screen);
  defaultvisual = DefaultVisual (dpy, screen);
  depth = DefaultDepth (dpy, screen);
  defaultcolormap = DefaultColormap (dpy, screen);

if(event->full==1){
  attributes.override_redirect = True;
  attr_mask |= CWOverrideRedirect;
  {
    Window wtmp;
    int tmp;
    XGetGeometry (dpy, RootWindow (dpy, screen),
		  &wtmp, &tmp, &tmp,
		  &x, &y, &border,
		  (unsigned int *) &tmp);
  }
} else {
  border = W_BORDER;
  attr_mask |= CWBorderPixel;
  x = W_WIDTH;
  y = W_HEIGHT;
}
  window = XCreateWindow (dpy, parent_window, 0, 0,
			  x, y, border, depth, class, defaultvisual,
			  attr_mask, &attributes);
  classHint.res_name = "xrsf";
  classHint.res_class = "xrsf";
  hints = XAllocWMHints ();
  hints->initial_state = NormalState;
  hints->window_group = window;
  hints->flags = (WindowGroupHint | StateHint);
  XSetWMProperties (dpy, window, NULL, NULL,
		    NULL, 1, NULL, hints, &classHint);
  XSetIconName (dpy, window, "  xrsf  ");
  wmDeleteWindow = XInternAtom (dpy, "WM_DELETE_WINDOW", False);
  XSetWMProtocols (dpy, window, &wmDeleteWindow, 1);
  gc = XCreateGC (dpy, window, 0L, &xgcvalues);
  XSetBackground (dpy, gc, BlackPixel (dpy, screen));
  XSetForeground (dpy, gc, WhitePixel (dpy, screen));
  XStoreName (dpy, window, "  xrsf  ");
  XMapWindow (dpy, window);
if(event->full==1)
  XSetInputFocus (dpy, window, RevertToNone, CurrentTime);


#if defined IMAGE
  image = XCreateImage (dpy, defaultvisual, depth, ZPixmap, 0, NULL, x, y, 8, 0);
  image->data = malloc (image->bytes_per_line * y);
  XSetBackground (dpy, gc, 0);
  //XSetFunction(dpy, gc, GXcopy);
  Buffer = window;
#elif defined IMAGESHM
  for (i = 0; i < NR_IMAGE; ++i)
    {
      image[i] = XShmCreateImage (dpy, defaultvisual, depth, ZPixmap, NULL, &shminfo[i], x, y);
      //image->data = malloc (image->bytes_per_line * y);
      shminfo[i].shmid = shmget (IPC_PRIVATE,
	     image[i]->bytes_per_line * image[i]->height, IPC_CREAT | 0777);


      shminfo[i].shmaddr = image[i]->data = shmat (shminfo[i].shmid, 0, 0);
      shminfo[i].readOnly = False;
      XShmAttach (dpy, &shminfo[i]);
    }
  XSetBackground (dpy, gc, 0);
  //XSetFunction(dpy, gc, GXcopy);
  Buffer = window;
  Completion = /*XShmGetEventBase (dpy) */ 65 + ShmCompletion;
  ready = 0;
  event->nr_i = 0;
  event->blackpixel = blackpixel = BlackPixel (dpy, screen);
  event->whitepixel = WhitePixel (dpy, screen);
  event->data[0] = /*(unsigned long *) */ image[0]->data;
  event->data[1] = /*(unsigned long *) */ image[1]->data;
  switch (depth)
    {
    case 24:
    case 32:
      event->bytes_line = image[0]->bytes_per_line >> 2;
      break;
    case 16:
    case 8:
      event->bytes_line = image[0]->bytes_per_line >> 1;
      break;
    }
  event->depth = depth;
  // event->bytes_line = image[0]->bytes_per_line>>2;
#else
  Buffer = window;
#endif
  event->height = y;
  event->width = x;
  height = event->height;
  width = event->width;
  colormap = XCreateColormap (dpy, window, defaultvisual, AllocNone);
  event->ready = 1;
  i = 0;
  printf ("%d\n", depth);
  return 1;
}

int
x11_close ()
{
  unsigned long pixels[color_nr];
  int i;
  for (i = 0; i < color_nr; i++)
    pixels[i] = color[i].pixel;
  XFreeColors (dpy, colormap, pixels, color_nr, 0);

#if defined IMAGE
  XDestroyImage (image);
#elif defined IMAGESHM
  for (i = 0; i < NR_IMAGE; ++i)
    {
      XDestroyImage (image[i]);
      XShmDetach (dpy, &shminfo[i]);
      shmdt (shminfo[i].shmaddr);
      shmctl (shminfo[i].shmid, IPC_RMID, 0);
    }
#endif
  XSync (dpy, 0);
  XFreeColormap (dpy, colormap);
  XUnmapWindow (dpy, window);
  XDestroyWindow (dpy, window);
  XCloseDisplay (dpy);

  return 1;
}

