#include "config.h"
#include "gi.h"
#include "info.h"
#ifdef USE_X11
#include "Xint.h"
#endif
#ifdef USE_VGA
#include "VGAint.h"
#endif

ginter gi;

extern struct info info;

int init_gi(void)
{
	switch (info.drv) {
#ifdef USE_X11
	case X11_DRV:
		gi.resize = x11_resize;
		gi.close_gi = x11_close;
		gi.color_background = x11_back;
		gi.color_foreground = x11_fore;
		gi.swap_buffer = x11_swap;
		gi.get_event = x11_event;
		return (x11_init());
#endif
#ifdef USE_VGA
	case SVGA_DRV:
		gi.resize = lvga_resize;
		gi.close_gi = lvga_close;
		gi.color_background = lvga_back;
		gi.color_foreground = lvga_fore;
		gi.swap_buffer = lvga_swap;
		gi.get_event = lvga_event;
		gi.set_palette = lvga_palette;
		return (lvga_init());
#endif
	default:
		return -1;
	}
}
