.ig
Copyright (C) 2002  Ben Kibbey <bjk@arbornet.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
..
.TH cave 1
.SH NAME
.
cave - Play ascii character animations.
.
.SH SYNOPSIS
.
.B cave
[
.B -hvSsqd
] [
.BI -f \ fps
] [
.BI -c \ cue
] [
.BI -r \ regex
] [
.BI -t \ seconds
]
.IR file
.IR ...
.
.SH DESCRIPTION
.
.B cave
is an acronym for Character Animation Viewer for Everyone. It plays ascii
character animations with an
.BR curses (3)
interface. 
.B cave
tries to determine the location of the frame deliminator automatically (top or
bottom of the frame).
Files compressed with
.BR gzip (1)
are supported.
.
.SH OPTIONS
.
.TP
.BI -f \ fps
Initial frames-per-second. The default is 15.
.TP
.BI -c \ cue
Skip this many frames when using the cue keys. The default is 8.
.TP
.BI -r \ regex
An alternate extended regular expression used to specify a frame deliminator.
See
.B REGEX EXAMPLES
below.
.TP
.B -d
Make a specified frame deliminator a value for a frame delay. This is the
default if no alternate frame delay is specified.
.TP
.B -s
Go directly into screensaver mode on startup cycling through multiple files.
.TP
.B -S
Go directly into screensaver mode shuffling the order of files if more than
one file is specified.
.TP
.B -q
When in screensaver mode, quit after a keypress.
.TP
.BI -t \ seconds
When in screensaver mode, if an animations length is less than this amount of
seconds then it will loop until it is reached. The default is 30. Note that
this only works when more than one file is specified.
.TP
.B -h
Program help text.
.TP
.B -v
Version and copyright information.
.
.SH INTERACTIVE COMMANDS
.
Press 'h' after loading a file to see a list of available interactive
commands.
.
.SH REGEX EXAMPLES
.
.TP
^[0-9]+[[:space:]]*$
Match a line beginning (^) with at least one (+) digit ([0-9]) with zero or
more (*) trailing whitespace characters until end-of-line ($). This is
the default and is used for frame delays.
.TP
^,$
Match a line beginning with a comma immediately followed by end-of-line.
.
.SH SEE ALSO
.
.BR re_format (7),
.BR gzip (1)
.
.SH AUTHOR
.
Copyright (C) 2002 Ben Kibbey <bjk@arbornet.org>. Distributed under the terms
of the GNU General Public License version 2.
