program exa_bars
    use dislin
    implicit none
    character (len=60) :: ctit
    character (len=24) :: cbuf
    character (len=8)  :: cdev
    real, dimension (9), parameter :: &
       xx  = (/1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0/), yy = 0.0, &
       yy1 = (/1.0,1.5,2.5,1.3,2.0,1.2,0.7,1.4,1.1/), &
       yy2 = (/2.0,2.7,3.5,2.1,3.2,1.9,2.0,2.3,1.8/), &
       yy3 = (/4.0,3.5,4.5,3.7,4.0,2.9,3.0,3.2,2.6/)
    real, dimension (9) :: x,y,y1,y2,y3
    integer, parameter :: nya=2700
    integer :: i

    ctit="Bar Graphs (BARS)"
    x=xx                        ! Arrays in BARS can be IN/OUT 
    y=yy
    y1=yy1
    y2=yy2
    y3=yy3

    write (unit=6,fmt="(a)",advance="no") &
       "Device (xwin, cons, gksl, ps, pdf, png, tiff, svg): "
    read (unit=5,fmt="(a)") cdev
    call metafl(cdev)
 
    call setpag("da4p")
    call disini()
    call pagera()
    call complx()
    call ticks(1,"x")
    call intax()
    call axslen(1600,700)
    call titlin(ctit,3)
 
    call legini(cbuf,3,8)
    call leglin(cbuf,"First",1)
    call leglin(cbuf,"Second",2)
    call leglin(cbuf,"Third",3)
    call legtit(" ")
    call shdpat(5)
    do i=1,3
      if(i > 1) then
        call labels("none","x")
      end if

      call axspos(300,nya-(i-1)*800)
      call graf(0.0,10.0,0.0,1.0,0.0,5.0,0.0,1.0)
 
      if(i == 1) then
        call bargrp(3,0.15)
        call color("red")
        call bars(x,y,y1,9)
        call color("green")
        call bars(x,y,y2,9)
        call color("blue")
        call bars(x,y,y3,9)
        call color("white")
        call reset("bargrp")
      else if(i == 2) then
        call height(30)
        call labels("delta","bars")
        call labpos("center","bars")
        call color("red")
        call bars(x,y,y1,9)
        call color("green")
        call bars(x,y1,y2,9)
        call color("blue")
        call bars(x,y2,y3,9)
        call color("white")
        call reset("height")
      else if(i == 3) then
        call labels("second","bars")
        call labpos("outside","bars")
        call color("red")
        call bars(x,y,y1,9)
        call color("white")
      end if
 
      if(i /= 3) then
        call legend(cbuf,7)
      end if

      if(i == 3) then
        call height(50)
        call title()
      end if
 
      call endgrf()
    end do
 
    call disfin()
end program exa_bars
