program exa_conshd
    use dislin
    implicit none
    integer, parameter :: n=50
    real, dimension (n) :: xray,yray
    real, dimension (n,n) :: zmat
    real, dimension (12)  :: zlev
    real    :: step,x,y
    character (len=8) :: cdev
    integer :: i,j
 
    step=1.6/(n-1)
    do i=1,n
      x=0.0+(i-1)*step
      xray(i)=x
      do j=1,n
        y=0.0+(j-1)*step
        yray(j)=y
        zmat(i,j)=(x*x-1.0)**2 + (y*y-1.0)**2
      end do
    end do

    write (unit=6,fmt="(a)",advance="no") &
       "Device (xwin, cons, gksl, ps, pdf, png, tiff, svg): "
    read (unit=5,fmt="(a)") cdev
    call metafl(cdev)

    call setpag("da4p")
    call disini()
    call pagera()
    call complx()
 
    call mixalf()
    call titlin("Shaded Contour Plot",1)
    call titlin("F(X,Y) = (X[2$ - 1)[2$ + (Y[2$ - 1)[2$",3)
    call name("X-axis","x")
    call name("Y-axis","y")
 
    call shdmod("poly","contur")
    call axspos(450,2670)
    call graf(0.0,1.6,0.0,0.2,0.0,1.6,0.0,0.2)
 
    do i=1,12
      zlev(13-i)=0.1+(i-1)*0.1
    end do
 
    call conshd(xray,n,yray,n,zmat,zlev,12)
 
    call height(50)
    call title()
    call disfin()
end program exa_conshd  
