program exa_contour
    use dislin
    implicit none
    integer, parameter :: n=50
    real, dimension (n) :: xray,yray
    real, dimension (n,n) :: zmat
    character (len=8) :: cdev 
    integer :: i,j
    real    :: fpi,step,zlev
 
    fpi=3.14159/180.0
    step=360.0/(n-1)
    do i=1,n
      xray(i)=(i-1)*step
      yray(i)=(i-1)*step
    end do
 
    do i=1,n
      do j=1,n
        zmat(i,j)=2*sin(xray(i)*fpi)*sin(yray(j)*fpi)
      end do
    end do

    write (unit=6,fmt="(a)",advance="no") &
       "Device (xwin, cons, gksl, ps, pdf, png, tiff, svg): "
    read (unit=5,fmt="(a)") cdev
    call metafl(cdev)
 
    call setpag("da4p")
    call disini()
    call complx()
    call pagera()
 
    call titlin("Contour Plot",1)
    call titlin("F(X,Y) = 2 * SIN(X) * SIN(Y)",3)
 
    call name("X-axis","x")
    call name("Y-axis","y")
 
    call intax()
    call axspos(450,2670)
    call graf(0.0,360.0,0.0,90.0,0.0,360.0,0.0,90.0)
 
    call height(30)
    do i=1,9
      zlev=-2.0+(i-1)*0.5
      call setclr(i*25)
      if(i == 5) then
        call labels("none","contur")
      else
        call labels("float","contur")
      end if
      call contur(xray,n,yray,n,zmat,zlev)
    end do
 
    call height(50)
    call color("white")
    call title()
 
    call disfin()
end program exa_contour 
