program exa_surface
    use dislin
    implicit none
    integer, parameter :: n=50
    real, dimension (n,n) :: zmat
    character (len=60) :: ctit1, ctit2
    character (len=8) :: cdev 
    real    :: fpi,step,x,y
    integer :: i,j

    ctit1 = "Surface Plot (SURMAT)"
    ctit2 = "F(X,Y) = 2*SIN(X)*SIN(Y)"
 
    fpi=3.14159/180.0
    step = 360.0/(n-1)
    do i=1,n
      x=(i-1)*step
      do j=1,n
        y=(j-1)*step
        zmat(i,j)=2*sin(x*fpi)*sin(y*fpi)
      end do
    end do
 
    write (unit=6,fmt="(a)",advance="no") &
       "Device (xwin, cons, gksl, ps, pdf, png, tiff, svg): "
    read (unit=5,fmt="(a)") cdev
    call metafl(cdev)


    call setpag("da4p")
    call disini()
    call pagera()
    call complx()
    call axspos(200,2600)
    call axslen(1800,1800)
    call name("X-axis","x")
    call name("Y-axis","y")
    call name("Z-axis","z")
    call titlin(ctit1,2)
    call titlin(ctit2,4)
 
    call view3d(-5.0,-5.0,4.0,"abs")
    call graf3d(0.0,360.0,0.0,90.0,0.0,360.0,0.0,90.0,-3.0,3.0,-3.0,1.0)
    call height(50)
    call title()
 
    call color("green")
    call surmat(zmat,n,n,1,1)
 
    call disfin()
end program exa_surface 
