
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: fs_browser.h,v 1.2 2000/04/28 20:46:33 dr Exp $ 
*/


#ifndef _FS_BROWSER_H_
#define _FS_BROWSER_H_


#include <gtk/gtkctree.h>

#define TYPE_FS_BROWSER            (fs_browser_get_type ())
#define FS_BROWSER(obj)            (GTK_CHECK_CAST ((obj), TYPE_FS_BROWSER, FSBrowser))
#define FS_BROWSER_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_FS_BROWSER, FSBrowserClass))
#define IS_FS_BROWSER(obj)         (GTK_CHECK_TYPE ((obj), TYPE_FS_BROWSER))
#define IS_FS_BROWSER_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))

#define MAX_PATH_LENGTH 4096

typedef struct _FSBrowser FSBrowser;
typedef struct _FSBrowserClass FSBrowserClass;

struct _FSBrowser {
    GtkCTree tree;

    char path_buffer [MAX_PATH_LENGTH];
};

struct _FSBrowserClass {
    GtkCTreeClass parent_class;
    
    void (*select_file) (FSBrowser *file_browser, char *file_path);
};


GtkType             fs_browser_get_type (void);
GtkWidget*          fs_browser_new (char *root_path);


#endif /* __FILE_BROWSER_H__ */
