
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: main.c,v 1.14 2000/04/28 20:46:34 dr Exp $ 
*/

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <gtk/gtk.h>
#include <gdk/gdkrgb.h>

#include "browser.h"
#include "../lib/dcache.h"


#include "../lib/draw.h"
#include "../lib/jpeg.h"
#include "../lib/png_module.h"
#include "../lib/scale.h"
#include "../lib/xpm_module.h"

static void              register_modules ();
static void              on_signal (int sig_num);

char *                   program_name = NULL;

void
exit_application () {

  gtk_main_quit ();
  dcache_finalize ();
  image_print_leaks ();
}

int
main (int argc, char **argv) {
  char buf [PATH_MAX];
  char *home;
#if 0
  mtrace ();
#endif

  if ((program_name = strrchr (argv [0], '/')))
    program_name ++;
  else
    program_name = argv [0];

  home = getenv ("HOME");
  if (home) {
    snprintf (buf, PATH_MAX, "%s/.%s.gtk", home, program_name);
    gtk_rc_add_default_file (buf);
  }

  g_thread_init (NULL);
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  gdk_rgb_init ();
  
  gtk_widget_set_default_colormap (gdk_rgb_get_cmap ());
  gtk_widget_set_default_visual (gdk_rgb_get_visual ());

  register_modules ();

  signal (SIGHUP, on_signal);
  signal (SIGINT, on_signal);
  signal (SIGQUIT, on_signal);
  signal (SIGABRT, on_signal);
  signal (SIGBUS, on_signal);
  signal (SIGSEGV, on_signal);
  signal (SIGPIPE, on_signal);
  signal (SIGTERM, on_signal);
  signal (SIGFPE, on_signal);

  
  browser_new (getcwd (NULL, 0));

  gtk_main ();

  return 0;
}

static void
on_signal (int sign_num) {

  fprintf (stderr, "Application received signal %d\n", sign_num);

  g_on_error_query (program_name);
  exit_application ();
}

static void
register_modules () {

  dcache_initialize ();

  draw_get_type ();
  jpeg_get_type ();
  png_get_type ();
  scale_get_type ();
  xpm_get_type ();
}



