
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: scrolled.h,v 1.3 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _SCROLLED_H_
#define _SCROLLED_H_

#include <gtk/gtk.h>


#define SCROLLED_TYPE             (scrolled_get_type())
#define SCROLLED(obj)             GTK_CHECK_CAST( (obj), SCROLLED_TYPE, Scrolled)
#define SCROLLED_X(scrolled, x) (-SCROLLED(scrolled)->x_offset + (x))
#define SCROLLED_Y(scrolled, y) (-SCROLLED(scrolled)->y_offset + (y))
#define SCROLLED_VX(scrolled, x) (SCROLLED(scrolled)->x_offset + (x))
#define SCROLLED_VY(scrolled, y) (SCROLLED(scrolled)->y_offset + (y))


typedef struct _Scrolled Scrolled;
typedef struct _ScrolledClass ScrolledClass;


struct _Scrolled {
  GtkContainer container;

  int         x_offset;
  int         y_offset;

  GtkAdjustment *h_adjustment;
  GtkAdjustment *v_adjustment;

  GdkGC       *copy_gc;
  guint       freeze_count;
};


struct _ScrolledClass {
  GtkContainerClass parent_class;

  void              (*set_scroll_adjustments) (GtkWidget *widget, 
					       GtkAdjustment *hadjustment, 
					       GtkAdjustment *vadjustment);
  void              (*adjust_adjustments) (Scrolled *scrolled);
};

GtkType    scrolled_get_type (void);

void       scrolled_realize (Scrolled *scrolled);
void       scrolled_unrealize (Scrolled *scrolled);
void       scrolled_freeze (Scrolled *scrolled);
void       scrolled_thawn (Scrolled *scrolled);

#endif /* _SCROLLED_H_ */
