
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: zalbum.h,v 1.3 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _ZALBUM_H_
#define _ZALBUM_H_

#include "zlist.h"
#include "../lib/image.h"
#include "../lib/gpengine.h"

#define ZALBUM_COLUMNS 3

#define ZALBUM_TYPE               (zalbum_get_type ())
#define ZALBUM(widget)            (GTK_CHECK_CAST ((widget), ZALBUM_TYPE, ZAlbum))
#define ZALBUM_CLASS(klass)	  (GTK_CHECK_CLASS_CAST ((klass), ZALBUM_TYPE, ZAlbumClass))
#define IS_ZALBUM(widget)	  (GTK_CHECK_TYPE ((widget), ZALBUM_TYPE))
#define IS_ZALBUM_CLASS(klass)	  (GTK_CHECK_CLASS_TYPE ((klass), ZALBUM_TYPE))


typedef struct _ZAlbum                 ZAlbum;
typedef struct _ZAlbumCell             ZAlbumCell;
typedef struct _ZAlbumClass            ZAlbumClass;
typedef struct _ZAlbumColumnInfo       ZAlbumColumnInfo;

typedef enum {
  ZALBUM_MODE_LIST,
  ZALBUM_MODE_PREVIEW,
  ZALBUM_MODES
} ZAlbumMode;

enum {
  ZALBUM_CELL_SELECTED     = 1 << 1,
  ZALBUM_CELL_RENDERED     = 1 << 2,
};

struct _ZAlbumColumnInfo {
  int  width;
  int  pad;
  int  flags;
};

struct _ZAlbum {
  ZList list;

  int   mode;

  ZAlbumColumnInfo    cinfo [ZALBUM_COLUMNS];

  int max_pix_width;
  int max_pix_height;

  GPEngine *gpe;
  int      render_cell;
  int      rendered_cells;
};

struct _ZAlbumClass {
  ZListClass parent_class;
};

struct _ZAlbumCell {
  int         flags;
  Image       *image;
  ImagePixmap *ipix;
};

GtkType              zalbum_get_type ();

GtkWidget *          zalbum_new (ZAlbumMode mode);
void                 zalbum_add (ZAlbum *album, Image *image);
void                 zalbum_set_mode (ZAlbum *album, ZAlbumMode mode);
gfloat               zalbum_get_progress (ZAlbum *album);

#define              zalbum_freeze(album)       (scrolled_freeze (SCROLLED(album)))
#define              zalbum_thawn(album)        (scrolled_thawn  (SCROLLED(album)))

#endif /* _ZALBUM_H_ */
