
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: directory.h,v 1.2 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _DIRECTORY_H_
#define _DIRECTORY_H_

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <glib.h>

typedef struct _Directory        Directory;

struct _Directory {
  guint      refcount;
  char       *name;
  time_t     mtime;
};

Directory *        directory_new (char *path);
Directory *        directory_ref (Directory *dir);
void               directory_unref (Directory *dir);
Directory *        directory_find (char *path);
int                directory_compare_mtime (char *d1, char *d2);
char *             directory_ref_by_name (char *path);
void               directory_unref_by_name (char *path);

#endif /* _DIRECTORY_H_ */
