
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: filter.h,v 1.3 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _FILTER_H_
#define _FILTER_H_

#include "module.h"
#include "image.h"

#define FILTER_TYPE          (filter_get_type ())
#define FILTER(module)       ((Filter *) module)
#define IS_FILTER(module)    MODULE_CHECK_CAST (MODULE (module), FILTER_TYPE)
#define FILTER_CLASS(module) ((FilterClass *) MODULE_CLASS (module))
#define FILTER_USE_X(filter) (FILTER_CLASS (filter)->flags & FILTER_USE_X)

typedef struct _Filter       Filter;
typedef struct _FilterTile   FilterTile; 
typedef struct _FilterClass  FilterClass;

#include "gpengine.h"

enum {
  FILTER_USE_X           = 1 << 0,
  FILTER_NEED_BUFFER     = 1 << 1
};

struct _Filter {
  Module      module;

  Image       *image;

  int         src_width, src_height, src_bpp;
  int         src_tile_width, src_tile_height;
  int         out_width, out_height, out_bpp;
  int         out_tile_width, out_tile_height;

  /* private */
  int         initialized : 1;

  guint       buffer_size;
  FilterTile  *buffer;

  GPEngine    *gpe;
};

struct _FilterTile {
  int        width, height, bpp;
  guchar     *data;
};

struct _FilterClass {
  ModuleClass    parent_class;

  int            flags;

  int            (* filter_init) (Filter *filter);
  int            (* filter_process_tile) (Filter *filter, FilterTile *src, FilterTile *out);
  void           (* filter_end) (Filter *filter);

  int            (* run) (Filter *filter);

  void           (* free_outputs) (Filter *filter);
};

ModuleType       filter_get_type ();

#define          filter_add_output_data(filter, name, type, value) \
                     gpengine_add_output_data (FILTER (filter)->gpe, name, type, value)

/* internal */
void             filter_alloc_buffer (Filter *filter);
int              filter_init (Filter *filter, Image *image,
			      int src_width, int src_height, int src_bpp,
			      int src_tile_width, int src_tile_height);
inline int       filter_process_tile (Filter *filter, FilterTile *src);
int              filter_end (Filter *filter);

int              filter_run (Filter *filter);
void             filter_free_outputs (Filter *filter);

FilterTile *     filter_tile_alloc (guint size);
void             filter_tile_free (FilterTile *tile);

#endif /* _FILTER_H_ */
