
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: mcache.h,v 1.5 2000/04/28 20:46:34 dr Exp $ 
*/

#ifndef _MCACHE_H_
#define _MCACHE_H_

#include "filter.h"

#define MCACHE_TYPE         mcache_get_type ()
#define MCACHE(module)      ((MCache *) module)

typedef struct _MCache        MCache;
typedef struct _MCacheClass   MCacheClass;


struct _MCache {
  Filter       filter;
  
  ImageCache   *cache;
  guchar       *cache_pos;
  
  int          rows_read;
  int          row_stride;

  int          dcache;
};

struct _MCacheClass {
  FilterClass  filter_class;
};

ModuleType              mcache_get_type ();

Module *                mcache_new (int dcache);
ImageCache *            mcache_get_cache (MCache *mc);

#endif /* _MCACHE_H_ */

