
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: param.h,v 1.10 2000/04/28 20:46:35 dr Exp $ 
*/

#ifndef _PARAM_H_
#define _PARAM_H_

#include <stdio.h>
#include <glib.h>

#define PARAM_NODE(gnode)   ((Param *) (gnode)->data)

typedef union  _ParamValue    ParamValue;
typedef struct _Param         Param;
typedef struct _ParamI        ParamI;
  
/* Parameter's flags */
enum {
  PARAM_INPUT               = 1 << 0,
  PARAM_OUTPUT              = 1 << 1,
  PARAM_PRIVATE             = 1 << 2,

  /* internal */
  PARAM_DEFAULT_VALUE_SET   = 1 << 8,
  PARAM_VALUE_SET           = 1 << 9,
  PARAM_IS_ARRAY            = 1 << 10
};

typedef enum {
  PARAM_TYPE_UNKNOWN,
  PARAM_TYPE_BOOLEAN,
  PARAM_TYPE_LONG,
  PARAM_TYPE_DOUBLE,
  PARAM_TYPE_STRING,
  PARAM_TYPE_POINTER,
  PARAM_TYPE_NODE,
  PARAM_TYPE_ALIAS,
  PARAM_TYPE_LAST
} ParamType;

union _ParamValue {
  gulong        v_long;
  gdouble       v_double;
  gchar *       v_string;
  gpointer      v_pointer;
  GArray *      v_array;
  GNode *       v_alias;
};

struct _Param {
  guint        refcount;

  char         *name;
  char         *label;
  char         *help;

  ParamType    type;
  guint        flags;

  ParamValue   default_value;
  ParamValue   value;
};

struct _ParamI {
  Param        *param;
  ParamValue   value;
};

Param *                     param_new (char *name, int flags, char *label, char *help,
				       ParamType type, ParamValue value);
Param *                     param_ref (Param *param);
void                        param_unref (Param *param);
ParamValue *                param_get_value (Param *param, ParamType type);
void                        param_set_value (Param *param, ParamType type, ParamValue value);
void                        param_clear_value (Param *param);
Param *                     param_find (GNode *parent, char *path);
void                        param_dump (Param *param, FILE *file);
GNode *                     param_get_root_node ();

ParamI *                    parami_new (Param *param, ParamType type, ParamValue value);
ParamValue *                parami_get_value (ParamI *parami, ParamType type);
void                        parami_set_value (ParamI *parami, ParamType type, ParamValue value);
void                        parami_free (ParamI *parami);

GNode *                     param_node_parse (GNode *parent, FILE *file);
GNode *                     param_node_parse_from_string (GNode *parent, char *string);
GNode *                     param_node_find (GNode *parent, char *path);
void                        param_node_dump (GNode *node, FILE *file);


#define                     param_new_nl(name) \
                                   param_new (name, 0, NULL, NULL, PARAM_TYPE_NODE, \
                                              (ParamValue) (gulong) 0)
#define                     param_node_new(name, flags, label, help, type, value) \
                                   g_node_new (param_new (name, flags, label, help, type, value))
#define                     param_node_new_nl(name) \
                                   g_node_new (param_new_nl (name))

GNode *                     param_node_add_child (GNode *parent, GNode *child);
#define                     param_node_add_param(parent, param) \
                                   param_node_add_child (parent, g_node_new (param))
#endif /* _H_ */







