
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: paramui.c,v 1.2 2000/04/28 20:46:35 dr Exp $ 
*/

#include "paramui.h"

#define insert_node(pui, parent, name) \
            gtk_ctree_insert_node (GTK_CTREE ((pui)->tree), \
				   (parent), NULL, \
				   &(name), \
				   0, \
				   NULL, NULL, NULL, NULL, \
				   0, 1) 

static void             param_ui_buildw (ParamUI *pui);
static void             param_ui_build_tree (ParamUI *pui, GNode *gnode, GtkCTreeNode *cnode);
static void             param_ui_select_node (GtkCTree *tree,
					      GtkCTreeNode *cnode,
					      int column,
					      ParamUI *pui);
					      
ParamUI *
param_ui_new (GNode *root) {
  ParamUI *pui;

  if (!root)
    root = param_get_root_node ();

  pui        = g_new (ParamUI, 1);
  pui->root  = root;

  param_ui_buildw (pui);
  param_ui_build_tree (pui, root, NULL);
  
  gtk_signal_connect (GTK_OBJECT (pui->tree), "tree_select_row",
		      (GtkSignalFunc) param_ui_select_node, pui);
		      
  return pui;
}

static void             
param_ui_buildw (ParamUI *pui) {
  GtkWidget *window;
  GtkWidget *sw;
  GtkWidget *paned;
  GtkWidget *frame;
  
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size (GTK_WINDOW (window), 600, 350);

  paned  = gtk_hpaned_new ();
  gtk_container_add (GTK_CONTAINER (window), paned);

  frame  = gtk_frame_new (NULL);
  gtk_paned_add1 (GTK_PANED (paned), frame);
  gtk_widget_set_usize (frame, 200, -1);

  sw = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (frame), sw);

  pui->tree = gtk_ctree_new (1, 0);
  gtk_container_add (GTK_CONTAINER (sw), pui->tree);


  frame = gtk_frame_new (NULL);
  gtk_paned_add2 (GTK_PANED (paned), frame);

  pui->params = gtk_vbox_new (0, 0);
  gtk_container_add (GTK_CONTAINER (frame), pui->params);

  gtk_widget_show_all (window);
}

static void
param_ui_build_tree (ParamUI *pui, GNode *gnode, GtkCTreeNode *cnode) {
  GtkCTreeNode *node;

  if (!gnode || PARAM_NODE (gnode)->type != PARAM_TYPE_NODE)
    return;

  node = insert_node (pui, cnode, PARAM_NODE (gnode)->name);
  gtk_ctree_node_set_row_data (GTK_CTREE (pui->tree), node, gnode);

  param_ui_build_tree (pui, gnode->children, node);
  param_ui_build_tree (pui, gnode->next, cnode);
}

static void             
param_ui_select_node (GtkCTree *tree,
		      GtkCTreeNode *cnode,
		      int column,
		      ParamUI *pui) {
  GNode *gnode;

  gnode = gtk_ctree_node_get_row_data (GTK_CTREE (pui->tree), cnode);
  g_return_if_fail (gnode);
  
  printf ("selected node: %s\n", PARAM_NODE (gnode)->name);
}

