
/*
    Axv: Another X Image Viewer
    Copyright (C) 2000 David RAMBOZ 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: scale.h,v 1.3 2000/04/28 20:46:35 dr Exp $ 
*/

#ifndef _SCALE_H_
#define _SCALE_H_

#include <gdk/gdk.h>
#include "filter.h"

#define SCALE_TYPE              scale_get_type ()
#define SCALE(module)           ((Scale *) module)
#define IS_SCALE(module)        MODULE_CHECK_CAST (module, SCALE_TYPE)
#define SCALE_CLASS(module)     ((ScaleClass *) MODULE_CLASS (module))

typedef struct _Scale       Scale;
typedef struct _ScaleClass  ScaleClass;

enum {
  SCALE_DONT_MAGNIFY      = 1 << 0
};

struct _Scale {
  Filter    filter;

  int       flags;

  int       bounding_box_width;
  int       bounding_box_height;
  int       src_row_stride;

  GdkColor  background;
  int	    *x_map, *y_map;
  int       src_row;
  int       out_row;
};

struct _ScaleClass {
  FilterClass filter_class;
};

ModuleType               scale_get_type ();
Module *                 scale_new (int flags,
				    int bounding_box_width, 
				    int bounding_box_height, 
				    GdkColor *background);
/* internal */

int                      scale_process_tile_parts (Scale *scale, 
						   FilterTile *in, 
						   FilterTile *out, 
						   int sx, int ex);

#endif /* _SCALE_H_ */

