#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <Imlib.h>

/* some defines to let you control Imlib's behavior */
/* define only one of FAST or GOOD. */
#define FAST
#undef GOOD

/* define for piles of debugging output */
#define DEBUG

/* action structure */
typedef struct _action_def {
	int action;
	char key;
	char f1[255];
	struct _action_def *next_action;
} action_def;

/* action types */
#define NONE 0 
#define SHELL 1
#define QUIT 2
#define SKIP 3

/* prototypes */
void do_pic(char *filename, int cur, int total);
void kbd_action(char *file);
void parse_config(void);
void do_exec(char *file, char *cmd);
Window OpenWindow(void);
char TranslateKeyCode(XEvent *ev);

/* globals */
ImlibData *id;
Display *disp;
int width, height;
int scr;
Window win;
action_def *first_action;


main (unsigned int argc, char *argv[])
{
     char *config_file;
     unsigned int start_arg;
     ImlibInitParams imparam;
     unsigned int i;

     /* someday, we'll have better option processing, and this
	variable will become somewhat important.  */

     start_arg = 1;
     
     parse_config ();
     
     /* yeah, well, we should deal with -display... */

     if(!(disp = XOpenDisplay(NULL))) {
	  printf ("Cannot open display\n");
	  exit(127);
     }
     
     /* set up our imlib initialization flags */
     imparam.flags = PARAMS_SHAREDMEM | PARAMS_SHAREDPIXMAPS |
	  PARAMS_REMAP | PARAMS_FASTRENDER | PARAMS_HIQUALITY |
	  PARAMS_IMAGECACHESIZE | PARAMS_PIXMAPCACHESIZE;

     /* set the stuff that's always the same */
     imparam.sharedmem = 0;
     imparam.sharedpixmaps = 0;
     imparam.imagecachesize = 0;
     imparam.pixmapcachesize = 0;

#ifdef FAST
     imparam.remap = 1;
     imparam.fastrender = 1;
     imparam.hiquality = 0;
#endif

#ifdef GOOD
     imparam.remap = 0;
     imparam.fastrender = 0;
     imparam.hiquality = 1;
#endif

     id = Imlib_init_with_params(disp, &imparam);
     
     win = OpenWindow();
     
     for (i = start_arg ; i <= (argc - 1) ; i++)
	  do_pic(argv[i], i, argc - 1);
     
     return 0;
}


void do_pic(char *filename, int cur, int total)
{
     /* no point in recreating these every pass... */
     static Pixmap map;  
     static ImlibImage *current_pic;
     static int Dwidth, Dheight;
     static char title[80];

     sprintf(title, "%s (%d of %d)", filename, cur, total);

     XStoreName(disp,win,title); /* tell them what image we're on */
     
#ifdef DEBUG
     printf ("Reading %s\n", filename);
#endif
     
     /* Ah, now.  let's start into the Imlib works, shall we?  some
	errors get trapped, some go all to hell and would probably bring
	about disaster.  how unfortunate. */
     
     current_pic = Imlib_load_image (id, filename);
     
#ifdef DEBUG
     printf ("Loaded %s\n", filename);
#endif
     
     if (current_pic == NULL) {
	  printf ("Error loading: %s\n", filename);
	  return;
     }
     
     width = current_pic->rgb_width;
     height = current_pic->rgb_height;
     
     Dwidth = (int) DisplayWidth(disp,scr);
     Dheight = (int) DisplayHeight(disp,scr);

     if (!Imlib_render (id, current_pic, width, height)) {
	  printf("Imlib rendering failure.\n");
	  exit(127);
     }
     
     XResizeWindow (disp, win, width, height);
     map = Imlib_move_image(id, current_pic);
     XSetWindowBackgroundPixmap (disp, win, map);
     XClearWindow (disp, win);
     XSync (disp, True);
     kbd_action (filename);
     Imlib_free_pixmap (id, map);
     Imlib_kill_image (id, current_pic);
     XSetWindowBackground (disp, win, BlackPixel (disp, scr));
     XClearWindow (disp, win);
     
     return;
     
}

/* The original code to handle what got done with files was absoultely 
   revolting, even to me.   So remember, no matter how bad the string 
   manipulation in here is, it used to suck worse than this by a large
   margin.  */


void
kbd_action (char *file)
{
     action_def *action;
     int done = 0;

     XSelectInput (disp, win, KeyPressMask);

     do {
	  int parsed = 0;
	  XEvent xev;
	  char testme = 0;

	  while (testme == 0) {
	       XNextEvent (disp, &xev);
	       testme = TranslateKeyCode (&xev);
	  }
	  
#ifdef DEBUG
	  printf ("got: %c\n", testme);
#endif
	  /* find the action matching the key */

	  action = first_action;
	  do {
	       if (action->key != testme) {
		    if ((action->next_action == NULL) && (action->key !=
							  testme)) {
			 parsed = 1;
			 action = first_action;
		    }
		    else
			 action = action->next_action;
	       }
	       else
		    parsed = 1;
	  }
	  while (parsed == 0);
	  
	  if ((action->action != 0)) {
	       switch (action->action) {
	       case SHELL:
		    do_exec(file, action->f1);
		    done = 1;
		    break;

	       case QUIT:
		    exit(0);

	       case SKIP:
		    done = 1;
		    break;
	       }
	  }
	  

     } while (done == 0);
     
#ifdef DEBUG
     printf ("action %d\n", action->action);
#endif
     
}

/* she's kinda nasty, but it's getting a LOT better */

void parse_config(void) {
     /* declare about 10 million variables, in a really unsightly way. */
     
     int action_match, parsed, x;
     int done;
     char file[255];
     char line[80];
     char *next_str; 
     char *sub_str;
     action_def *next;
     action_def *build_action = (action_def *) malloc (sizeof (action_def));
     FILE *fp;
     
     build_action->action = 0;
     build_action->next_action = NULL;
     first_action = build_action;
     
     if(getenv("HOME") == NULL) {
	  printf("Enviornment variable HOME not set, unable to load configuration\n");
	  exit(127);
     }

     sprintf (file, "%s/.imagesortrc", getenv("HOME"));
     if((fp = fopen(file, "r")) == NULL) {
	  printf ("Error opening %s\n", file);
	  exit (1);
     }

     while(fgets(line, 80, fp) != NULL) {
	  char work[80];

	  parsed = 0;
	  strncpy(work, line, 80);

#ifdef DEBUG
	  printf ("parsing: %s\n", work);
#endif
      	  next_str = strtok (work, " ");

#ifdef DEBUG
	  printf("next_str: %x", next_str);
#endif
      
	  if (!strcasecmp ("kbd", next_str)) {
	       parsed = 1;
	       next_str =  strtok (NULL, " ");
	
#ifdef DEBUG
	       printf("next_str: %s", next_str);
#endif DEBUG
	
	       if (!strcasecmp ("cmd", next_str)) {
		    parsed = 1;
		    next = malloc (sizeof (action_def));
		    next->action = SHELL;
		    next->key = *strtok (NULL, " ");
		    sub_str = strtok (NULL, "\n");
		    strcpy(next->f1, sub_str);
		    next->next_action = NULL;
		    build_action->next_action = next;
		    build_action = next;
		    continue;
	       }
	  
	       if (!strcasecmp ("quit", next_str)) {
		    parsed = 1;
		    next = malloc (sizeof (action_def));
		    next->action = QUIT;
		    next->key = *strtok (NULL, " ");
		    next->next_action = NULL;
		    build_action->next_action = next;
		    build_action = next;
		    continue;
	       }
	       if (!strcasecmp ("skip", next_str)) {
		    parsed = 1;
		    next = malloc (sizeof (action_def));
		    next->action = SKIP;
		    next->key = *strtok (NULL, " ");
		    build_action->next_action = next;
		    next->next_action = NULL;
		    build_action = next;
		    continue;
	       }
	  }
	  
	  if (parsed == 0) {
	       printf ("Unknown config directive %s\n", work);
	       exit(127);
	  }
	  
     }
     
     fclose(fp);
     
     if (first_action->next_action == NULL) {
	  printf ("No actions defined.  Exiting.\n");
	  exit(127);
     }



  
#ifdef DEBUG
     printf("done building config crap\n");
#endif

}

void do_exec (char *file, char *command)
{

     char *args[11]; /* who the hell's needing more than 10 args? */
     char *copy;
     char *work;
     int i = 0;


     work = copy = strdup(command);
     
     /* if we've room, fish out the next arg, and replace it if it's
	the filename token */

     while((i < 9) && ((args[i] = strsep(&work, " ")) != NULL)) {
	  if(!strcmp(args[i], "%fn"))
	       args[i] = file;
	  i++;
     }

     /* strsep returned a NULL before the last word, it's stored where
	work points now */
     args[i] = work;
     args[i+1] = NULL;

#ifdef DEBUG
     {
	  int j;
	  
	  printf("running: ");
	  for(j = 0; j <= i; j++) 
	       printf("%s ", args[j]);
	       
	  printf("\n");
     }
#endif

     /* run the command now, double fork so we don't leave zombies
	about */
     if(fork() == 0) {
	  if(fork() == 0) {
	       /* grandchild, do the exec() */
	       execvp(args[0], args);
	       /* if this point is reached, there was an error */
	       perror("execvp");
	       exit(0);
	  } else 
	       exit(0); /* child, terminate for parent */
     }
     /* neither child or grandchild can reach here */
     /* pick up child proc */
     wait(NULL);

}

/* this finction may not need to exist, but I constantly change my
   mind on the way I want to handle going from image to image.   best
   to leave it here.   sort-of-taken from test.c in some old version
   of Imlib, but modified to suit my needs.  thanks, Imlib. */

Window
OpenWindow ()
{
  
  int win, blk;
  
  
  scr = DefaultScreen (disp);
  blk = BlackPixel (disp, scr);
  win = XCreateSimpleWindow (disp, DefaultRootWindow (disp), 0, 0, width + 2, height + 2, 0, blk, blk);
  XMapWindow (disp, win);
  XSync (disp, False);
  
  return win;
  
}

/* turn one-charaacter key events into a string to be sent back to 
   kbd_action...   return NULL if it can't be condensed nicely into
   one character.  theoretically, we could bash this so ctrl/meta/etc
   could be dealt with as viable key presses, but, who's really gonna
   need that many keys?  ("640k is enough for anybody....") */

/* oh, I kinda ripped this off from Xkey, but it's been rewritten to
   some extent...  but thanks anyway for demonstrating how to get
   keypresses. */

char TranslateKeyCode (XEvent * ev) {
     int count;
     char key_buff[5];
     KeySym ks;
     
     if (ev) {
	  if(XLookupString ((XKeyEvent *) ev, key_buff, 5,
			    &ks, NULL) == 1)
	       /* only return single-char keys */
	       return key_buff[0];
	  else
	       return 0;
     }
}

