/*
 * auto.c
 *	Automatic window height/width functions.
 *
 * Copyright (C) 1997 Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@trends.net)
 */
#include <wlib/rcs.h>
MU_ID("$Mu: mgv/auto.c,v 1.8 $")

#include <assert.h>
#include <Xm/Xm.h>
#include <Xm/XmStrDefs.h>

#include <wlib/wlib.h>
#include <mine/mgv.h>
#include <mine/auto.h>

/**
 ** Remember that MGV.root_width and MGV.root_height have wmWidth
 ** and wmHeight adjustments built in.
 **/

/*
 * Automatic height and width.
 */
void
mgv_auto_size(MGV *m)
{
	Dimension	gw, gh, mw, mh, cw, ch;
	assert(MgvOK(m));

	XtVaGetValues(m->ghost,
		XmNwidth,	&gw,
		XmNheight,	&gh,
		NULL);
	XtVaGetValues(m->clip,
		XmNwidth,	&cw,
		XmNheight,	&ch,
		NULL);
	XtVaGetValues(XtParent(m->main),
		XmNwidth,	&mw,
		XmNheight,	&mh,
		NULL);
	if((mw += gw - cw) > m->root_width
	&& (m->bits & MgvSMARTSIZE))
		mw = m->root_width;
	if((mh += gh - ch) > m->root_height
	&& (m->bits & MgvSMARTSIZE))
		mh = m->root_height;
	XtVaSetValues(XtParent(m->main), XmNwidth, mw, XmNheight, mh, NULL);
}

/*
 * Automatic width.
 */
void
mgv_auto_width(MGV *m)
{
	Dimension	gw, mw, cw;
	assert(MgvOK(m));

	XtVaGetValues(m->ghost,           XmNwidth, &gw, NULL);
	XtVaGetValues(m->clip,            XmNwidth, &cw, NULL);
	XtVaGetValues(XtParent(m->main),  XmNwidth, &mw, NULL);
	if((mw += gw - cw) > m->root_width
	&& (m->bits & MgvSMARTSIZE))
		mw = m->root_width;
	XtVaSetValues(XtParent(m->main), XmNwidth,  mw, NULL);
}

/*
 * Automatic height.
 */
void
mgv_auto_height(MGV *m)
{
	Dimension	gh, mh, ch;
	assert(MgvOK(m));

	XtVaGetValues(m->ghost,           XmNheight, &gh, NULL);
	XtVaGetValues(m->clip,            XmNheight, &ch, NULL);
	XtVaGetValues(XtParent(m->main),  XmNheight, &mh, NULL);
	if((mh += gh - ch) > m->root_height
	&& (m->bits & MgvSMARTSIZE))
		mh = m->root_height;
	XtVaSetValues(XtParent(m->main),  XmNheight,  mh, NULL);
}

/*
 * Automatic nothing.  Having an empty auto-sizer saved us from having to
 * litter the code with a bunch of ugly NULL checks.
 */
void
mgv_auto_none(MGV *m)
{
	USEUP(m);
}
