# @(#)$Mu: make/appdef.mk,v 1.15 $
##
## appdef.mk
##	Auxillary make rules for mu's makefiles.
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@trends.net)
##

##
## This Makefile requires GNU Make
##

##
## Application defaults processes is done in three stages:
##
##	adpp : Blah.ad.in -> Blah.ad (this takes care of all the m4 stuff)
##	sed  : Blah.ad    -> Blah    (variable subst. from sys.mk)
##	ad2c : Blah       -> _ad.c   (default resources for compiling)
##
## The first two steps are separate so that all the m4 stuff can be done
## _before_ the tar.gz archive is made (this way, you don't need m4 to
## compile things most of the time).
##

clean  += $(appdef) _ad.c
rclean += $(appdef).ad

$(appdef).ad:: $(appdef).ad.in $(wildcard res.m4 tools/standard.ad wlib/wlib/wlib.ad wlib/wlib/WlAppShell.ad)
	$(top)/tools/adpp $(sys) $(top) $(appdef).ad.in > $(appdef).ad

$(appdef):: $(appdef).ad
	sed -e 's;@@LIBDIR@@;$(libdir);g' -e 's;@@VERSION@@;$(version);g' \
		< $(appdef).ad > $(appdef)

_ad.o:: _ad.c
_ad.c:: $(appdef)
	$(top)/tools/ad2c -a bld_fallbacks $(appdef) > _ad.c

install-ad:: $(appdef)
	$(mkdir) $(addir)
	$(install) $(adflags) $(appdef) $(addir)/$(appdef)
