# @(#)$Mu: make/rules.mk,v 1.73 $
##
## rules.mk
##	Auxillary make rules for mu's makefiles.
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@trends.net)
##

##
## This Makefile requires GNU Make
##

##
## get local stuff
##
include $(top)/.toplevel.mk
-include extras.mk

##
## Nicer looking .c->.o and .cc->.o rules (easier to see what is being done
## with this one).
##
%.o: %.c
	$(cc) $(opt) $(warn) \
		$(defs) $(defs-$(notdir $(basename $<))) \
		$(incl) \
		-c $< \
		-o $@

%.o: %.cc
	$(cxx) $(opt) $(warn) $(cxxflags) \
		$(defs) $(defs-$(notdir $(basename $<))) \
		$(incl) \
		-c $< \
		-o $@

##
## SGML to whatever rules (you need the linuxdoc-sgml package for
## these), we use ``.sg'' instead of ``.sgml'' to allow for
## some preprocessing
##
%.sgml: %.sg
	$(top)/tools/sgmlpp $(version) $(libdir) $(top) $(projname) $< > $@ \
		|| rm -f $@

%.html: %.sgml
	sgml2html -img $<

%.info: %.sgml
	sgml2info $<

%.txt: %.sgml
	sgml2txt -f $<

##
## Since we can't explicitly name the output file we have
## to do things by hand here rather than just calling sgml2latex -p
##
%-a4.ps: %.sgml
	cp $< $(basename $<)-a4.sgml
	sgml2latex -a -d $(basename $<)-a4.sgml
	rm $(basename $<)-a4.sgml
	dvips -t a4 -f < $(basename $<)-a4.dvi > $@ || rm -f $@
	rm $(basename $<)-a4.dvi

%.ps: %.sgml
	sgml2latex -p $<

##
## GIF -> EPS rules, this rules requires that you set all of the
## scale-FILENAME variables even if they're all one.
##
%.ps: %.gif
	giftopnm $< | pnmscale $(scale-$(notdir $(basename $<))) \
		| ppmtopgm | pnmtops -scale 1 -noturn > $@ \
		|| (rm $@; exit 1)

##
## man page preprocessing
##
%.1: %.man
	$(top)/tools/manpp $(version) $(libdir) < $< > $@ || rm -f $@

all::

##
## spell checking support rules
##
.%.spell-t: %
	ispell -t -p $(top)/tools/words.ispell $<
	@touch $@

.%.spell-s: %
	ispell -p $(top)/tools/words.ispell $<
	@touch $@

##
## troff spell checking
##
ifdef spellcheck-t
spell:: $(addprefix ., $(addsuffix .spell-t, $(spellcheck-t)))
rclean += $(addprefix ., $(addsuffix .spell-t, $(spellcheck-t)))
else
spell::
endif

##
## SGML spell checking
##
ifdef spellcheck-s
spell:: $(addprefix ., $(addsuffix .spell-s, $(spellcheck-s)))
rclean += $(addprefix ., $(addsuffix .spell-s, $(spellcheck-s)))
else
spell::
endif

##
## if there are subdirectories, then go to it before anything else
##
ifdef subdirs
all::
	@for dir in $(subdirs); do $(MAKE) -C $$dir || exit 1; done
spell::
	@for dir in $(subdirs); do $(MAKE) -C $$dir spell || exit 1; done
rdep::
	@for dir in $(subdirs); do $(MAKE) -C $$dir rdep || exit 1; done
clean::
	@for dir in $(subdirs); do $(MAKE) -C $$dir clean || exit 1; done
realclean::
	@for dir in $(subdirs); do $(MAKE) -C $$dir realclean || exit 1; done
install-ad::
	@for dir in $(subdirs); do $(MAKE) -C $$dir install-ad || exit 1; done
install-man::
	@for dir in $(subdirs); do $(MAKE) -C $$dir install-man || exit 1; done
install-bin::
	@for dir in $(subdirs); do $(MAKE) -C $$dir install-bin || exit 1; done
install-doc::
	@for dir in $(subdirs); do $(MAKE) -C $$dir install-doc || exit 1; done
endif

##
## if there is an executable, then that's what we need to do
##
ifdef exe
include $(top)/make/executable.mk
else
install-bin::
install-man::
endif

ifdef lib
include $(top)/make/library.mk
endif

##
## the resource file
##
ifdef appdef
include $(top)/make/appdef.mk
else
install-ad::
endif

##
## install docs
##
ifdef docs
install-doc::
	$(mkdir) $(libdir)
	@for x in $(docs); do \
		echo $(install) $(libflags) $$x $(libdir)/$$x; \
		$(install) $(libflags) $$x $(libdir)/$$x; \
	done
else
install-doc::
endif

##
## install everything
##
install-bin:: all
install-ad::  all
install-man:: all
install-doc:: all
install:: install-bin install-ad install-man install-doc

##
## remove intermediate files
##
clean += $(wildcard *.o) core .pure .depend
clean::
	rm -rf $(clean)

##
## remove everything that can be generated
##
distclean:: realclean
realclean::
	rm -rf $(rclean) $(clean)

##
## build the dependency file
##
rdep:: dep
ifdef csrcs
dep::
	$(dep) $(dflags) $(csrcs) > .depend
else # csrcs
dep::
endif
