# @(#)$Mu: make/sys.hpux-gcc.mk,v 1.42 $
##
## sys.hpux-gcc.mk
##	System dependent makefile for HP-UX 9.05 with gcc.
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@trends.net)
##

sysname    = HP-UX 9.05 (gcc)
sys        = SY_HPUX
mk-putenv  = yes
mk-xpm     = yes
mk-libhelp = no
##
## Some have it and some don't (I don't know why) so I'll just default to
## the safest.
##
mk-editres = no

cc       = gcc
perl     = /usr/local/bin/perl
purify   = purify -chain-length="10"
quantify = quantify
cover    = purecov
warn     = -ansi -pedantic -W -Wall -Werror -Wmissing-prototypes
defs     = -D$(sys) -D_POSIX_SOURCE -D_XOPEN_SOURCE -D_HPUX_SOURCE
opt      = -O2
incl     = -I. -I/usr/local/include -I/usr/include/Motif1.2 -I/usr/X11/include
ldflags  = -s $(opt) -L/usr/local/lib -L/usr/lib/X11R5 -L/usr/lib/Motif1.2
xlibs    = -lXm -lXpm -lXmu -lXt -lX11 -lm
hlibs    = -lhlpclient
ar       = ar
arflags  = r
m4       = $(top)/tools/p4 -P

dep    = gcc
dflags = -M

mkdir    = mkdirhier
install  = $(top)/tools/mutstall
bindir   = /usr/local/bin
binflags = -o bin -g bin -m 755
mandir   = /usr/local/man/man1
manflags = -o bin -g bin -m 644
libdir   = /usr/local/lib/$(projname)
libflags = $(manflags)
addir    = $(libdir)
adflags  = $(libflags)
