# @(#)$Mu: make/sys.sco.mk,v 1.38 $
##
## sys.sco.mk
##	system dependent makefile for SCO 5.0
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@trends.net)
##

##
## SCO 5.0/cc
##
sysname    = SCO 5.0 (cc)
sys        = SY_SCO
mk-putenv  = yes
mk-xpm     = yes
mk-libhelp = no
mk-editres = yes

cc      = cc
perl    = /usr/local/bin/perl
warn    = -a xpg4 -Xc -w1 -wx -b elf
defs    = -D$(sys)
opt     = -O2
incl    = -I. -I/usr/local/include
ldflags = -a xpg4 -L/usr/local/lib $(opt)
xlibs   = -lXm -lXpm -lXmu -lXt -lXext -lX11 -lm -lintl -lsocket
hlibs   = -lhlpclient
ar      = ar
arflags = r
m4      = $(top)/tools/p4 -P

defs_socket = -U_POSIX_SOURCE -U_XOPEN_SOURCE

dep    = makedepend
dflags = -f-

mkdir    = mkdirhier
install  = $(top)/tools/mutstall
bindir   = /usr/local/bin
binflags = -o bin -g bin -m 755
mandir   = /usr/local/man/man1
manflags = -o bin -g bin -m 644
libdir   = /usr/local/lib/$(projname)
libflags = $(manflags)
addir    = $(libdir)
adflags  = $(libflags)
